<?php

class PeepSoCanvasPushHelper{
    private static $instance;

    public static function get_instance() {
        return isset(self::$instance) ? self::$instance : self::$instance = new self;
    }

    private function __construct() {
        if(FALSE && PeepSo3_Third_Party::has_mobile_wrapper_mobiloud_canvas() && PeepSo::get_option_new('app_peepso_canvas_push')) {

            // Modify the Profile > Notification preferences (header)
            add_filter('peepso_profile_alerts_form_fields', function($fields) {
                $form_headers = [
                    [
                        'label'     => 'canvas_push',
                        'type'      => 'label',
                        'html'      => '<i class="ps-tip gcis gci-mobile-alt" aria-label="'.__('App Push','peepso-app').'"></i>',
                    ]
                ];
                $fields['form_header']['fields'] = array_merge($fields['form_header']['fields'], $form_headers);

                return $fields;
            },9999,1);

            // Modify the Profile > Notification preferences (fields)
            add_filter('peepso_profile_alert_setting_fields', function($setting_fields, $setting, $key,$notifications) {
                $name_canvas_push = "{$setting}_canvas_push";
                $setting_fields[]= array(
                    'label' => 'canvas_push',
                    'name' => $name_canvas_push,
                    'type' => 'checkbox',
                    'group_key' => "__{$key}_canvas_push",
                    'value' => apply_filters('peepso_get_notification_value', !in_array($name_canvas_push, $notifications) ? 1 : 0, $name_canvas_push),
                );
                return $setting_fields;
            },9999,4);

            // DISABLED Modify the Profile > Notification preferences (shortcuts)
            add_action('peepso_render_notifications_preferences_shortcuts', function($is_realtime) {
                return;
                ?>
                <a class="ps-profile__notifications-shortcut ps-btn ps-btn--xs ps-js-preferences-button" role="menuitem"
                   data-action="disable"
                   data-type="canvas_push"
                   href="<?php echo admin_url('admin-ajax.php?action=peepso_user_unsubscribe_canvas_push&redirect')?>">
                    <?php echo __('Disable app push', 'peepso-app');?>
                </a>
                <?php
            },1,1);

            // Set cron flag to 0 if notification being created is enabled as mobile push
            add_filter('peepso_notifications_data_before_add', function($data){

                if(!$this->is_enabled($data)) { return $data; }

                // 0 means the notification needs to be pushed. The default is -1 meaning "do nothing"
                $data['not_processed_canvas_push'] = 0;

                return $data;
            });

            // Run together with MailQueue and process pushes that need to be sent
            add_action('peepso_action_process_mailqueue', [&$this, 'cron']);
        }
    }

    public function cron() {
        echo "<h1>Canvas push cron</h1>";
        global $wpdb;

        $limit = 50;
        $sql = "
        SELECT * FROM {$wpdb->prefix}".PeepSoNotifications::TABLE." `not`
        LEFT JOIN `{$wpdb->users}` `fu` ON `fu`.`ID` = `not`.`not_from_user_id`
        LEFT JOIN `{$wpdb->posts}` `p` ON `p`.ID = `not`.`not_external_id`
        LEFT JOIN `{$wpdb->prefix}" . PeepSoActivity::TABLE_NAME . "` `act` ON `act`.`act_external_id`=`p`.`id` 
        WHERE `not_processed_canvas_push`=0 AND `not_read`=0 ORDER BY `not_id` ASC LIMIT $limit";

        $res = $wpdb->get_results($sql);

        $processed = [];
        if(count($res)) {
            foreach($res as $notification) {
                // Store done notification IDs to set their not_processed_canvas_push flag to 1
                $processed[]=$notification->not_id;

                $notification = (array) $notification;
                $id = $notification['not_id'];
                $to_user_id = $notification['not_user_id'];
                $from_user_id = $notification['not_from_user_id'];
                $type = $notification['not_type'];
                $args = json_decode($notification['not_message_args'], TRUE);
                $message = $notification['not_message'];

                // If user disabled this notification after it was created
                if(!$this->is_enabled($notification)) {
                    continue;
                }

                // @TODO this code is a duplicate in mailqueue - we should centralize "not id to translated string" somewhere
                // Get translated notification message
                if(TRUE) {
                    $textdomain = array_shift($args);
                    $message = PeepSo3_MultiLang__($message, $textdomain, $to_user_id);

                    $args = apply_filters('peepso_filter_notification_args', $args);

                    // fire translation on args as well
                    if (count($args)) {
                        foreach ($args as &$arg) {
                            $arg = __($arg, $textdomain);
                        }

                        $message = vsprintf($message, $args);
                    }

                    $PeepSoUserFrom = PeepSoUser::get_instance($from_user_id);
                    $message = $PeepSoUserFrom->get_firstname() . " " . $message;
                }

                // Get notification link
                if(TRUE) {
                    $PeepSoProfile = PeepSoProfile::get_instance();
                    $link = $PeepSoProfile->notification_link(0, (array)$notification);
                }

                $PeepSoUserTo = PeepSoUser::get_instance($to_user_id);

                echo "
                            <small>
                            Notification $id  
                            / from  {$PeepSoUserFrom->get_firstname()}($from_user_id) 
                            / to {$PeepSoUserTo->get_firstname()}($to_user_id)
                            / length ".strlen($message)."
                            </small>
                            
                            <br/>
                            
                            <b><u><i>
                                $message
                            </i></u></b>
                            
                            <br>
                            
                            <a href='$link' target='_blank'>$link</a><hr>
                            ";
            }
        }
    }

    private function is_enabled($not) {

        $canvas_push_type = $not['not_type'] . '_canvas_push';

        // Posts in groups have a "special" notification setting
        if('groups_new_post' == $not['not_type']) {
            $group_id = get_post_meta($not['not_external_id'],'peepso_group_id',TRUE);
            if(is_int($group_id)) {
                $canvas_push_type = 'group_' . $group_id . '_canvas_push';
            }
        }

        $notifications = get_user_meta($not['not_user_id'], 'peepso_notifications');
        if (isset($notifications[0]) && in_array($canvas_push_type, $notifications[0])) {
            new PeepSoError('disabled '.$canvas_push_type);
            return FALSE;
        }

        new PeepSoError('enabled '.$canvas_push_type);
        return TRUE;
    }
}
