<?php

class PeepSoConfigSectionApp extends PeepSoConfigSectionAbstract {

    private $peepso_navigation_desc;

    public function register_config_groups()
    {
        $this->set_context('left');
        $this->gecko();


        $this->set_context('right');
        $this->general();
        $this->navigation();
        // $this->canvas_push();
    }

    private function navigation() {

        PeepSoGeneral::get_instance();

        $this->set_field(
            'app_peepso_navigation_separator',
            __('Community Links', 'peepso-app'),
            'separator'
        );

        /** COMMUNITY **/


        $links = apply_filters('peepso_navigation',[]);

        $exceptions = [];//['profile-home', 'profile'];

        foreach($links as $id => $link) {

            if(in_array($id, $exceptions)) {
                continue;
            }

            if(!$link['primary']) {
                continue;
            }

            if('profile-home' == $id) {
                $link['label'] = __('Profile link');
            }

            if('profile' == $id) {
                $link['label'] = __('Profile dropdown');
            }

            $this->args('descript', $id);
            $this->set_field(
                'app_peepso_navigation_hide_'.$id,
                sprintf(__('Disable %s','peepso-app'),  '<i>'.$link['label'].'</i>'),
                'yesno_switch'
            );
        }

        /** PROFILES **/

        $this->set_field(
            'app_peepso_profile_navigation_separator',
            __('Profiles','peepso-app'),
            'separator'
        );

        $links = apply_filters('peepso_navigation_profile',[]);

        $exceptions = ['stream', 'about'];

        foreach($links as $id => $link) {

            if(in_array($id, $exceptions)) {
                continue;
            }

            $this->args('descript', $id);
            $this->set_field(
                'app_peepso_navigation_profile_hide_'.$id,
                sprintf(__('Disable %s','peepso-app'),  '<i>'.$link['label'].'</i>'),
                'yesno_switch'
            );
        }


        /** GENERAL **/

        $this->set_field(
            'app_peepso_navigation_general_separator',
            __('General','peepso-app'),
            'separator'
        );


        $this->set_field(
            'app_peepso_navigation_profile_hide_log_out',
            sprintf(__('Disable %s','peepso-app'),  '<i>'.__('Log Out','peepso-app').'</i>'),
            'yesno_switch'
        );

        $this->set_field(
            'app_peepso_navigation_profile_hide_preferences',
            sprintf(__('Disable %s','peepso-app'),  '<i>'.__('Preferences','peepso-app').'</i>'),
            'yesno_switch'
        );



        $this->set_group(
            'peepso_navigation',
            'Navigation',
            __('Hide selected navigation items in app context. It can be used to hide certan functionality from the app. By hiding any e-commerce related links you improve your chances of getting the app approved by Apple.','peepso-app')
        );
    }


    private function general() {

        $this->args('descript','Hide the PeepSo Navigation Bar in app context. Recommended to maintain a clean app design and when you have app navigation solved otherwise.');
        $this->set_field(
            'app_peepso_disable_navbar',
            sprintf(__('Disable %s','peepso-app'),  __('PeepSo Navigation Bar','peepso-app')),
            'yesno_switch'
        );


        $this->args('default', 1);
        $this->set_field(
            'app_peepso_disable_activity_social_sharing',
            sprintf(__('Disable %s','peepso-app'),  '<i>'.__('Activity Social Sharing', 'peepso-core').'</i>'),
            'yesno_switch'
        );

        $this->args('default', 1);
        $this->set_field(
            'app_peepso_disable_activity_view_count',
            sprintf(__('Disable %s','peepso-app'),  '<i>'.__('Display view count', 'peepso-core').'</i>'),
            'yesno_switch'
        );

        $this->args('default', 1);
        $this->set_field(
            'app_peepso_disable_activity_comments_preload',
            __('Collapsed comments','peepso-app'),
            'yesno_switch'
        );

        $this->args('default', 1);
        $this->set_field(
            'app_peepso_disable_hover_cards',
            sprintf(__('Disable %s','peepso-app'),  '<i>'.__('Hover Cards', 'peepso-app').'</i>'),
            'yesno_switch'
        );

        $this->set_group(
            'peepso_ui',
            'PeepSo UI elements',
            '',
        );
    }

    private function canvas_push() {

        if(PeepSo3_Third_Party::has_mobile_wrapper_mobiloud_canvas()) {
            $this->set_field(
                'app_peepso_canvas_push',
                __('Enabled', 'peepso-app'),
                'yesno_switch'
            );
        }

        $this->set_group(
            'canvas_push',
            'Push notifications',
            'Requires MobiLoud Canvas plugin to be installed, activated and <a href="'.admin_url('admin.php?page=canvas&tab=push').'" target="_blank">configured</a>'
        );
    }

    private function gecko() {

      if(class_exists('Gecko_Customizer')) {
          $this->set_field(
              'app_gecko_hide_header_footer_separator',
              __('Disable Gecko features', 'peepso-app'),
              'separator'
          );
          // Gecko header & footer
          $this->set_field(
              'app_gecko_hide_header',
              sprintf(__('Disable %s', 'peepso-app'), __('header', 'peepso-app')),
              'yesno_switch'
          );

          $this->set_field(
              'app_gecko_hide_footer',
              sprintf(__('Disable %s', 'peepso-app'), __('footer', 'peepso-app')),
              'yesno_switch'
          );

          $this->set_field(
              'app_gecko_hide_page_titles',
              sprintf(__('Disable %s', 'peepso-app'), __('page titles', 'peepso-app')),
              'yesno_switch'
          );

          $this->set_field(
              'app_gecko_hide_scroll_to_top',
              sprintf(__('Disable %s', 'peepso-app'), __('scroll-to-top button', 'peepso-app')),
              'yesno_switch'
          );

          // Widget locations

          $this->set_field(
              'app_gecko_hide_widgets_separator',
              __('Disable widget locations', 'peepso-app'),
              'separator'
          );

          $exceptions = ['peepso', 'wp_inactive_widgets'];
          $locations = wp_get_sidebars_widgets();
          global $wp_registered_sidebars;

          foreach ($wp_registered_sidebars as $id => $sidebar) {

              if (in_array($id, $exceptions) || substr($id, 0, 5) == 'mobi-') {
                  continue;
              }

              $name = (isset($sidebar['name']) && strlen($sidebar['name'])) ? $sidebar['name'] : $id;

              $this->args('descript', $id);
              $this->set_field(
                  'app_gecko_hide_widgets_' . $id,
                  '<b>' . sprintf(__('Disable %s', 'peepso-app'), '</b><i>' . $name . '</i>'),
                  'yesno_switch'
              );
          }

      }
        $this->set_group(
            'gecko',
            'Gecko',
            sprintf(__('Requires %s to be the active theme. Child themes or hot-swapping themes in app context are currently not supported.','peepso-app'),'<b>PeepSo Theme: Gecko</b>')
        );
    }
}