<?php
/**
 * Plugin Name: PeepSo Integrations: Mobile App with MobiLoud
 * Plugin URI: https://PeepSo.com
 * Description: Additional options for PeepSo plugins and Gecko theme in app wrapper context. Requires the MobiLoud Canvas plugin.
 * Author: PeepSo
 * Version: 7.0.1.0
 * Author URI: https://PeepSo.com
 * Copyright: (c) PeepSo, Inc. All Rights Reserved.
 * License: GPLv2 or later (PHP), property of PeepSo, Inc. (CSS, JavaScript, images)
 * License URI: http://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: peepso-app
 * Domain Path: /language
 *
 * The PHP code of this plugin is Open Source. This PHP software can be redistributed and/or modified under the terms of the 
 * GNU General Public License (version 2 or later), as published by the Free Software Foundation. 
 * See the GNU General Public License or the LICENSE file for more details.  
 *  
 * Unless explicitly stated otherwise inside the respective files, all CSS, JavaScript, and images included in this plugin are proprietary to PeepSo, Inc.  
 * They are protected by copyright and other applicable intellectual property laws. 
 * Unauthorized use, reproduction, or distribution of these assets is STRICTLY PROHIBITED.  
 *  
 * "PeepSo" and "Your Community. Your Way." are registered trademarks of PeepSo, Inc.  
 *
 * This software is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY. 
*/

class PeepSoAppPlugin
{
    private static $instance = NULL;

    const PLUGIN_NAME    = 'Integrations: Mobile App';
    const PLUGIN_VERSION = '7.0.1.0';
    const PLUGIN_RELEASE = ''; //ALPHA1, BETA1, RC1, '' for STABLE

    const PLUGIN_EDD = 33515961;
    const PLUGIN_SLUG = 'mobile-app-integration';

	private static function ready() {
        if (class_exists('PeepSo') && PeepSo::ready(self::PLUGIN_VERSION)) {
            return TRUE;
        }
    }

    public function __construct() {

        /** VERSION INDEPENDENT hooks **/

        // Admin
        add_filter('peepso_license_config', function($list){
            $data = array(
                'plugin_slug' => self::PLUGIN_SLUG,
                'plugin_name' => self::PLUGIN_NAME,
                'plugin_edd' => self::PLUGIN_EDD,
                'plugin_version' => self::PLUGIN_VERSION
            );
            $list[] = $data;
            return ($list);
        });

        if (is_admin()) {
            add_action('admin_init', array(&$this, 'peepso_check'));
            add_action('admin_notices', function(){
                if(!PeepSo3_Third_Party::has_mobile_wrapper()) {
                    ?>
                    <div class="error peepso">

                            The <strong>PeepSo Mobile App Integration</strong> plugin needs <strong><a href="https://Peep.So/MobiLoud" target="_blank">MobiLoud Canvas</a></strong> to be installed and activated.<br/><br/>

                            To learn more and find out about wrapper alternatives, please check our <a href="https://www.peepso.com/documentation/getting-started-with-peepso-mobile-app-integration/" target="_blank">documentation</a>.
                    </div>
                    <?php
                }
            });
        }

        // Compatibility
        add_filter('peepso_all_plugins', function($plugins){
            $plugins[plugin_basename(__FILE__)] = get_class($this);
            return $plugins;
        });

        // Translations
        add_action('init', function(){
            $path = dirname(__FILE__) . DIRECTORY_SEPARATOR . 'language' . DIRECTORY_SEPARATOR . 'peepso-app-' . determine_locale() . '.mo';
            load_textdomain('peepso-app', $path);
        });

        /** VERSION LOCKED hooks **/

        if (self::ready()) {

            if (!PeepSoLicense::check_license(self::PLUGIN_EDD, self::PLUGIN_SLUG)) {
                return;
            }

            PeepSo::add_autoload_directory(dirname(__FILE__) . DIRECTORY_SEPARATOR . 'classes' . DIRECTORY_SEPARATOR);

            if(PeepSo3_Third_Party::has_mobile_wrapper()) {
                add_filter('peepso_admin_config_tabs', function ($tabs) {
                    $tabs['app'] = array(
                        'label' => __(' App', 'peepso-app'),
                        'icon' => 'https://cdn.peepso.com/icons/plugins/'.self::PLUGIN_EDD.'.svg',
                        'tab' => 'app',
                        'description' => 'Mobile App',
                        'function' => 'PeepSoConfigSectionApp',
                        'cat' => 'integrations',
                    );

                    return $tabs;
                }, -1);
            }

            /** CANVAS PUSH */
            PeepSoCanvasPushHelper::get_instance();

            /** FRONTEND OVERRIDES **/

            if(!is_admin() && PeepSoAppHelper::is_app() ) {

                /******** WordPress ********/

                // Disable admin bar
                add_filter('show_admin_bar', '__return_false', 9999);

                // Load app-only scripts.
                add_action('wp_enqueue_scripts', array(&$this, 'enqueue_scripts'));

                /********* PeepSo *********/

                // Disable PeepSo Navigation Bar
                add_filter('peepso_filter_get_option_disable_navbar', function ($value) {
                    if (1 == PeepSo::get_option('app_peepso_disable_navbar', 0)) {
                        return 1;
                    }

                    return $value;
                }, 999999, 2);

                // Disable PeepSo Navigation links
                add_filter('peepso_navigation', function ($links) {
                    foreach ($links as $id => $link) {
                        if (1 == PeepSo::get_option('app_peepso_navigation_hide_' . $id, 0)) {
                            unset($links[$id]);
                        }
                    }
                    return $links;
                }, 999999);

                // Disable PeepSo profile Navigation links
                add_filter('peepso_navigation_profile', function ($links) {
                    foreach ($links as $id => $link) {
                        if (1 == PeepSo::get_option('app_peepso_navigation_profile_hide_' . $id, 0)) {
                            unset($links[$id]);
                        }
                    }
                    return $links;
                }, 999999);

                // Disable other non-filtered links

                add_filter('peepso_filter_navigation_preferences', function($show) {
                    if(PeepSo::get_option_new('app_peepso_navigation_profile_hide_preferences')) {
                        $show = FALSE;
                    }
                    return $show;
                },9999,1);

                add_filter('peepso_filter_navigation_log_out', function($show) {
                    if(PeepSo::get_option_new('app_peepso_navigation_profile_hide_log_out')) {
                        $show = FALSE;
                    }
                    return $show;
                },9999,1);

                // Optimize PeepSo infinite scrolls
                add_filter('peepso_filter_activity_limit_below_fold',function($limit){
                    return 1;
                });

                // Disable social sharing on posts
                add_filter('peepso_filter_get_option_activity_social_sharing_enable', function($value) {
                    if (1 == PeepSo::get_option('app_peepso_disable_activity_social_sharing', 1)) {
                        $value = 0;
                    }

                    return $value;
                });

                // Disable view count on posts
                add_filter('peepso_filter_get_option_post_view_count_show', function($value) {
                    if (1 == PeepSo::get_option('app_peepso_disable_activity_view_count', 1)) {
                        $value = 0;
                    }

                    return $value;
                });

                // Collapse comments
                add_filter('peepso_filter_get_option_site_activity_comments', function($value) {
                    if (1 == PeepSo::get_option('app_peepso_disable_activity_comments_preload', 1)) {
                        $value = 0;
                    }

                    return $value;
                });

                // Disable hover cards
                add_filter('peepso_filter_get_option_hovercards_enable', function($value) {
                    if (1 == PeepSo::get_option('app_peepso_disable_hover_cards', 1)) {
                        $value = 0;
                    }

                    return $value;
                });
            }
        }
    }

    public static function get_instance()
    {
        return isset(self::$instance) ? self::$instance : self::$instance = new self;
    }

    public function peepso_check()
    {
        if (!class_exists('PeepSo')) {
            add_action('admin_notices', array(&$this, 'peepso_disabled_notice'));
            unset($_GET['activate']);
            deactivate_plugins(plugin_basename(__FILE__));
            return (FALSE);
        }

        // PeepSo.com license check
        if (!PeepSoLicense::check_license(self::PLUGIN_EDD, self::PLUGIN_SLUG)) {
            add_action('admin_notices', array(&$this, 'license_notice'));
        }

        if (isset($_GET['page']) && 'peepso_config' == $_GET['page'] && !isset($_GET['tab'])) {
            add_action('admin_notices', array(&$this, 'license_notice_forced'));
        }

        if(method_exists('PeepSoLicense', 'check_updates_new')) {
            PeepSoLicense::check_updates_new(self::PLUGIN_EDD, self::PLUGIN_SLUG, self::PLUGIN_VERSION, __FILE__);
        }

        return (TRUE);
    }

    public function license_notice()
    {
        PeepSo::license_notice(self::PLUGIN_NAME, self::PLUGIN_SLUG);
    }

    public function license_notice_forced()
    {
        PeepSo::license_notice(self::PLUGIN_NAME, self::PLUGIN_SLUG, true);
    }

    public function peepso_disabled_notice()
    {
        ?>
        <div class="error peepso">
            <strong>
                <?php
                echo sprintf(__('The %s plugin requires the PeepSo plugin to be installed and activated.', 'peepso-app'), self::PLUGIN_NAME),
                ' <a href="plugin-install.php?tab=plugin-information&amp;plugin=peepso-core&amp;TB_iframe=true&amp;width=772&amp;height=291" class="thickbox">',
                __('Get it now!', 'peepso-app'),
                '</a>';
                ?>
            </strong>
        </div>
        <?php
    }

    public function enqueue_scripts() {
        wp_enqueue_script('peepso-app',
            PeepSo::get_asset('js/index.js', __FILE__),
            array('peepso'), self::PLUGIN_VERSION, TRUE);
    }
}

PeepSoAppPlugin::get_instance();
// EOF
