(function( $, peepso, factory ) {

	ps_edd = peepso.edd = factory( $, peepso );

})( jQuery || $, peepso, function( $, peepso ) {

/*
 * PeepSo Messages class
 * @package PeepSo
 * @author PeepSo
 */

function PsEDD()
{
	//
}

var ps_edd = new PsEDD();

/**
 * Displays the list of products and hides the summary.
 */
PsEDD.prototype.show_long_products = function()
{
	$("#summary-products").hide();
	$("#long-products").fadeIn();
};


$(function() {
	$( document ).on( 'click.ps-edd__slider-wrapper', '.ps-edd__slider-btn', function() {
		var $btn = $( this ),
			step = +$btn.data( 'step' ),
			direction = step > 0 ? 'next' : step < 0 ? 'prev' : '',
			$wrapper, wrapperWidth, scrollLeft;

		if ( ! direction ) {
			return;
		}

		$wrapper = $btn.closest( '.ps-edd__slider-wrapper' ).children( '.ps-edd__slider' );
		wrapperWidth = $wrapper.width();
		$wrapper.children( '.ps-edd__slider-item' ).each(function() {
			var position;

			$item = $( this );
			position = $item.position();
			if ( direction === 'next' ) {

				if ( Math.floor( position.left ) > 0 ) {
					scrollLeft = $wrapper.scrollLeft() + position.left;
					return false;
				}
			} else if ( direction === 'prev' ) {
				if ( Math.floor( position.left ) < 0 ) {
					scrollLeft = $wrapper.scrollLeft() + position.left;
				}
			}
		});

		if ( typeof scrollLeft === 'number' ) {
			$wrapper.animate({ scrollLeft: scrollLeft }, 'fast' );
		}
	});
});

return ps_edd;

});
