<?php

class PeepSoConfigSectionEDD extends PeepSoConfigSectionAbstract
{
	// Builds the groups array
	public function register_config_groups()
	{
		$this->context = 'left';
		$this->group_general();

		$this->context = 'right';
		$this->group_activity();

		if (class_exists('EDD_All_Access')) {
			$this->group_all_access();
		}
	}


	/**
	 * General Settings Box
	 */
	private function group_general()
	{
		$this->set_field(
			'peepso_edd_tab',
			__('Profile Tab Display', 'peepso-edd'),
			'separator'
		);

		$this->args('descript', 
		__('Available tabs:','peepso-edd')
		. '<br/>' . __('downloads','peepso-edd')
		. '<br/>' . __('orders','peepso-edd')
		. '<br/>' . __('licenses <b style="color:red">(requires EDD Software Licensing plugin)</b>','peepso-edd')
		. '<br/>' . __('subscriptions <b style="color:red">(requires EDD Recurring Payments plugin)</b>','peepso-edd')
		. '<br/>' . __('all-access <b style="color:red">(requires EDD All Access plugin)</b>','peepso-edd')
		);

		$this->set_field(
			'peepso_edd_profile_tabs',
			__('Profile tabs', 'peepso-edd'),
			'textarea'
		);

		$this->args('descript', __('Rename the tab or leave empty for default value.', 'peepso-edd'));
		$this->set_field(
			'peepso_edd_tab_downloads_label',
			__('<code>Downloads</code> tab', 'peepso-edd'),
			'text'
		);

		$this->args('descript', __('Rename the tab or leave empty for default value.', 'peepso-edd'));
		$this->set_field(
			'peepso_edd_tab_orders_label',
			__('<code>Orders</code> tab', 'peepso-edd'),
			'text'
		);

		if (class_exists('EDD_Software_Licensing')) {
			$this->args('descript', __('Rename the tab or leave empty for default value.', 'peepso-edd'));
			$this->set_field(
				'peepso_edd_tab_licenses_label',
				__('<code>Licenses</code> tab', 'peepso-edd'),
				'text'
			);
		}

		if (class_exists('EDD_Recurring')) {
			$this->args('descript', __('Rename the tab or leave empty for default value.', 'peepso-edd'));
			$this->set_field(
				'peepso_edd_tab_subscriptions_label',
				__('<code>Subscriptions</code> tab', 'peepso-edd'),
				'text'
			);
		}

		if (class_exists('EDD_All_Access')) {
			$this->args('descript', __('Rename the tab or leave empty for default value.', 'peepso-edd'));
			$this->set_field(
				'peepso_edd_tab_all_access_label',
				__('<code>All Access</code> tab', 'peepso-edd'),
				'text'
			);
		}

		$this->set_group(
			'peepso_edd',
			__('General', 'peepso-edd'),
			__('Here you can enable or disable EDD tabs in profile page of the user.', 'peepso-edd')
		);
	}

	private function group_activity()
	{
		$this->set_field(
			'peepso_edd_activity',
			__('Orders', 'peepso-edd'),
			'separator'
		);

		$this->args('default', 1);
		$this->set_field(
			'peepso_edd_display_purchase',
			__('Post new purchases to stream', 'peepso-edd'),
			'yesno_switch'
		);

		$this->args('default', 1);
		$this->set_field(
			'peepso_edd_display_purchase_override',
			__('Users can override this setting', 'peepso-edd'),
			'yesno_switch'
		);

		$this->set_field(
			'peepso_edd_display_purchase_content',
			__('Action text', 'peepso-edd'),
			'text'
		);

		$this->args('default', 1);
		$this->set_field(
			'peepso_edd_display_free_purchase',
			__('Enable for free purchases', 'peepso-edd'),
			'yesno_switch'
		);

		$this->set_group(
			'peepso_edd',
			__('Shopping Activity', 'peepso-edd'),
			__('Automatic stream posts when someone makes an order', 'peepso-edd')
		);
	}

	private function group_all_Access()
	{

		$shortcode_parameter_name  = 'peepso_edd_all_access_parameter_';

		$parameter_name = 'all_access_customer_<br/>downloads_only';
		$this->args('descript', __('Only show products that the customer has access to through All Access.', 'peepso-edd'));
		$this->args('default', 1);
		$this->set_field(
			$shortcode_parameter_name  . $parameter_name,
			'<code>' . $parameter_name . '</code>',
			'yesno_switch'
		);

		$parameter_name = 'category';
		$this->args('descript', __('Specify multiple download category IDs using comma separated values. For example: 1,2,3.<br/>Leave empty to not show product in specific category. ', 'peepso-edd'));
		$this->args('default', '');
		$this->set_field(
			$shortcode_parameter_name  . $parameter_name,
			'<code>' . $parameter_name . '</code>',
			'text'
		);

		$parameter_name = 'exclude_category';
		$this->args('descript', __('Specify multiple download category IDs using comma separated values. For example: 1,2,3.<br/>Leave empty to not hide product in specific category. ', 'peepso-edd'));
		$this->args('default', '');
		$this->set_field(
			$shortcode_parameter_name  . $parameter_name,
			'<code>' . $parameter_name . '</code>',
			'text'
		);

		$parameter_name = 'tags';
		$this->args('descript', __('Specify multiple download tag IDs using comma separated values. For example: 1,2,3.<br/>Leave empty to not show product in specific tag. ', 'peepso-edd'));
		$this->args('default', '');
		$this->set_field(
			$shortcode_parameter_name  . $parameter_name,
			'<code>' . $parameter_name . '</code>',
			'text'
		);

		$parameter_name = 'exclude_tags';
		$this->args('descript', __('Specify multiple download tag IDs using comma separated values. For example: 1,2,3.<br/>Leave empty to not hide product in specific tag. ', 'peepso-edd'));
		$this->args('default', '');
		$this->set_field(
			$shortcode_parameter_name  . $parameter_name,
			'<code>' . $parameter_name . '</code>',
			'text'
		);

		$parameter_name = 'relation';
		$options = array(
            'OR' => __('OR', 'peepso-edd'),
            'AND' => __('AND', 'peepso-edd'),
		);
        $this->args('options', $options);
		$this->args('descript', __('Specify whether the products displayed have to be in ALL the categories/tags provided, or just in at least one.', 'peepso-edd'));
		$this->args('default', '');
		$this->set_field(
			$shortcode_parameter_name  . $parameter_name,
			'<code>' . $parameter_name . '</code>',
			'select'
		);

		$parameter_name = 'number';
		$this->args('descript', __('Specify the maximum number of products to be displayed by the shortcode.<br/>Leave empty for default value.', 'peepso-edd'));
		$this->args('default', '100');
        $this->args('validation', array('numeric'));
		$this->set_field(
			$shortcode_parameter_name  . $parameter_name,
			'<code>' . $parameter_name . '</code>',
			'text'
		);

		$parameter_name = 'columns';
		$this->args('descript', __('Specify the maximum number of columns to be displayed by the shortcode.<br/>Leave empty for default value.', 'peepso-edd'));
		$this->args('default', '3');
        $this->args('validation', array('numeric'));
		$this->set_field(
			$shortcode_parameter_name  . $parameter_name,
			'<code>' . $parameter_name . '</code>',
			'text'
		);

		$parameter_name = 'price';
		$this->args('descript', __('Show price for each product.', 'peepso-edd'));
		$this->args('default', 0);
		$this->set_field(
			$shortcode_parameter_name  . $parameter_name,
			'<code>' . $parameter_name . '</code>',
			'yesno_switch'
		);

		$parameter_name = 'excerpt';
		$this->args('descript', __('Show excerpt for each product.', 'peepso-edd'));
		$this->args('default', 0);
		$this->set_field(
			$shortcode_parameter_name  . $parameter_name,
			'<code>' . $parameter_name . '</code>',
			'yesno_switch'
		);

		$parameter_name = 'full_content';
		$this->args('descript', __('Show full content for each product.', 'peepso-edd'));
		$this->args('default', 0);
		$this->set_field(
			$shortcode_parameter_name  . $parameter_name,
			'<code>' . $parameter_name . '</code>',
			'yesno_switch'
		);

		$parameter_name = 'buy_button';
		$this->args('descript', __('Show buy button/download button for each product.', 'peepso-edd'));
		$this->args('default', 1);
		$this->set_field(
			$shortcode_parameter_name  . $parameter_name,
			'<code>' . $parameter_name . '</code>',
			'yesno_switch'
		);

		$parameter_name = 'thumbnails';
		$this->args('descript', __('Show thumbnails for each product.', 'peepso-edd'));
		$this->args('default', 1);
		$this->set_field(
			$shortcode_parameter_name  . $parameter_name,
			'<code>' . $parameter_name . '</code>',
			'yesno_switch'
		);

		$parameter_name = 'orderby';
		$options = array(
            'ID' => __('ID', 'peepso-edd'),
            'post_date' => __('post_date', 'peepso-edd'),
			'price' => __('price', 'peepso-edd'),
            'random' => __('random', 'peepso-edd'),
            'title' => __('title', 'peepso-edd'),
		);
        $this->args('options', $options);
		$this->args('descript', __('Specify whether the products displayed have to be in ALL the categories/tags provided, or just in at least one.', 'peepso-edd'));
		$this->args('default', 'post_date');
		$this->set_field(
			$shortcode_parameter_name  . $parameter_name,
			'<code>' . $parameter_name . '</code>',
			'select'
		);

		$parameter_name = 'order';
		$options = array(
            'ASC' => __('ASC', 'peepso-edd'),
            'DESC' => __('DESC', 'peepso-edd'),
		);
        $this->args('options', $options);
		$this->args('descript', __('Specify whether the products displayed have to be in ALL the categories/tags provided, or just in at least one.', 'peepso-edd'));
		$this->args('default', 'ASC');
		$this->set_field(
			$shortcode_parameter_name  . $parameter_name,
			'<code>' . $parameter_name . '</code>',
			'select'
		);

		$parameter_name = 'ids';
		$this->args('descript', __('Specify multiple download IDs using comma separated values. For example: 1,2,3.<br/>Leave empty to not show product in specific ID. ', 'peepso-edd'));
		$this->args('default', '');
		$this->set_field(
			$shortcode_parameter_name  . $parameter_name,
			'<code>' . $parameter_name . '</code>',
			'text'
		);

		$shortcode_parameters_checkbox = array(
			'ids',
		);

		$this->set_group(
			'peepso_edd',
			__('All Access Settings', 'peepso-edd'),
			__('Here you can configure <code>[download]</code> shortcode parameters.', 'peepso-edd')
		);
	}

}