<?php 

add_filter('edd_template_paths', function($file_paths) {
    unset($file_paths[1]);
    return $file_paths;
});

add_action('edd_purchase_link_top', function($download_id, $args) {
    ob_get_clean();
    ob_start();
}, 10, 2);

$shortcode ='[downloads ';

$shortcode_parameters = array(
    'all_access_customer_downloads_only' => 1,
    'category' => '',
    'exclude_category' => '',
    'tags' => '',
    'exclude_tags' => '',
    'relation' => 'OR',
    'number' => 100,
    'price' => 0,
    'excerpt' => 0,
    'full_content' => 0,
    'buy_button' => 1,
    'columns' => 3,
    'thumbnails' => 1,
    'orderby' => 'post_title',
    'order' => 'ASC',
    'ids' => '',
);

foreach ($shortcode_parameters as $key => $value) {
    $shortcode_value = PeepSo::get_option('peepso_edd_all_access_parameter_' . $key, $value);
    if (!in_array($key, ['number', 'columns']) && is_int($shortcode_value)) {
        if (in_array($key, ['thumbnails']) && is_int($shortcode_value)) {
            $shortcode_value = ($shortcode_value === 1) ? 'true' : 'false';
        } else {
            $shortcode_value = ($shortcode_value === 1) ? 'yes' : 'no';
        }
    }

    if ($shortcode_value !== '') {
        $shortcode .= $key . '="' . $shortcode_value . '" ';
    }
}

$shortcode .= ']';
echo do_shortcode($shortcode); 

?>