<?php

if (isset($_GET['license_id'])) {
    // check if valid license for user
    $license_id  = absint( $_GET['license_id' ] );
    $download_id = absint( edd_software_licensing()->get_download_id( $license_id ) );
    $download    = new EDD_Download( $download_id );
    $user_id     = edd_software_licensing()->get_user_id( $license_id );

    if (!$user_id) {
        $page = __('Invalid license', 'peepso-edd');
    } else {
        if (isset($_GET['view']) && $_GET['view'] == 'upgrades') {
            $template = 'upgrades';
        } else  {
            $template = 'manage-single';
        }

        ob_start();
        edd_get_template_part('licenses', $template);
        $page = ob_get_clean();
    }
} else {
    $page = do_shortcode('[edd_license_keys]');

    $purchase_history_page = edd_get_option('purchase_history_page', 0);

    // replace purchase history link
    if (get_post_status($purchase_history_page)) {
        $link = get_permalink($purchase_history_page) . '?';

        $page = str_replace($link, $current_url, $page);
        $page = str_replace('&#038;action=manage_licenses', '', $page);
    }

    // replace purchase confirmation link to orders tab
    $success_page = edd_get_option('success_page', 0);
    if (get_post_status($success_page)) {
        $link = get_permalink($success_page) . '?';
        $page = str_replace($link, str_replace('licenses', 'orders', $current_url), $page);
    }
}

echo $page;
?>