<?php

class BadgeOS_PeepSoTriggers
{
    /**
     * Create default album for user after user register
     * @param object PeepSoUser
     */
    public static function register_approved($user)
    {
        self::badgeos_peepso_trigger_event($user->get_id(), current_filter());
    }

    /**
     * Function called after avatar changed
     * @param user_id
     * @param dest_thumb
     * @param dest_full
     * @param dest_orig
     */
    public static function user_after_change_avatar($user_id, $dest_thumb, $dest_full, $dest_orig)
    {
        if(0 !== $user_id){
            self::badgeos_peepso_trigger_event($user_id, current_filter());
        }
    }

    /**
     * Function called after cover changed
     * @param user_id
     * @param dest_file
     */
    public static function user_after_change_cover($user_id, $dest_file)
    {
        if(0 !== $user_id){
            self::badgeos_peepso_trigger_event($user_id, current_filter());
        }
    }

    /**
     * @param int The WP post ID
     * @param int The act_id
     */
	public static function activity_after_add_post($post_id, $act_id)
	{
        $post = get_post( $post_id ); 
        $user_ID = $post->post_author;

        if ($post->post_type == PeepSoActivityStream::CPT_POST) {
            self::badgeos_peepso_trigger_event($user_ID, current_filter());   
        }
	}

    /**
     * @param int The WP post ID
     * @param int The act_id
     */
	public static function after_add_comment($post_id, $act_id, $did_notify, $did_email)
	{
        $post = get_post( $post_id ); 
        $user_ID = $post->post_author;

        $current_filter = current_filter();

        if (class_exists('PeepSoGroupsPlugin')) {
            $peepso_activity = new PeepSoActivity();
            $activity = $peepso_activity->get_activity($act_id);

            if (is_object($activity) && $activity->act_comment_module_id && $activity->act_comment_module_id == PeepSoGroupsPlugin::MODULE_ID) {
                $current_filter = 'peepso_groups_after_add_comment';
            }
        }

        self::badgeos_peepso_trigger_event($user_ID, $current_filter);
	}

    /**
     * @param int The WP post ID
     * @param int The act_id
     */
	public static function activity_after_repost($post_id, $act_id)
	{
        $post = get_post( $post_id ); 
        $user_ID = $post->post_author;

        if ($post->post_type == PeepSoActivityStream::CPT_POST) {
            self::badgeos_peepso_trigger_event($user_ID, current_filter());   
        }
	}

    /**
     * @param object The react object
     */
	public static function action_react_add($react)
	{
        if (class_exists('PeepSoGroupsPlugin') && $react->react_module_id == PeepSoGroupsPlugin::MODULE_ID) {
            $current_filter = 'peepso_groups_action_react_add';
        } else {
            $current_filter = current_filter();
        }
        
        self::badgeos_peepso_trigger_event($react->react_user_id, $current_filter);   
	}

    /**
     * @param int from user id
     * @param int to user id
     */
    public static function friends_requests_after_add($from_id, $to_id)
    {
        self::badgeos_peepso_trigger_event($from_id, current_filter());
    }

    /**
     * @param int from user id
     * @param int to user id
     */
	public static function friends_requests_after_accept($from_id, $to_id)
	{
		self::badgeos_peepso_trigger_event($from_id, current_filter());
		self::badgeos_peepso_trigger_event($to_id, current_filter());
	}

    /**
     * @param int message_id
     */
    public static function messages_new_conversation($message_id)
    {
        if(0 !== $message_id)
        {
            $msg = get_post($message_id);
            $user_id = $msg->post_author;
            self::badgeos_peepso_trigger_event($user_id, current_filter());
        }
    }

    /**
     * @param obj PeepSoGroup
     */
    public static function action_group_create($group)
    {
        self::badgeos_peepso_trigger_event($group->owner_id, current_filter());
    }

    /**
     * @param int group_id
     * @param int user_id
     */
    public static function action_group_user_join($group_id, $user_id)
    {
        $args['peepso_group_id'] = $group_id;
        self::badgeos_peepso_trigger_event($user_id, current_filter(), $args);
    }

    /**
     * Function called after avatar changed
     * @param user_id
     * @param dest_thumb
     * @param dest_full
     * @param dest_orig
     */
    public static function groups_after_change_avatar($group_id, $dest_thumb, $dest_full, $dest_orig)
    {
        if(0 !== $group_id){
            $PeepSoGroup = new PeepSoGroup($group_id);
            $user_id = get_current_user_id();
            self::badgeos_peepso_trigger_event($user_id, current_filter());
        }
    }

    /**
     * Function called after cover changed
     * @param user_id
     * @param dest_file
     */
    public static function groups_after_change_cover($group_id, $dest_file)
    {
        if(0 !== $group_id){
            $PeepSoGroup = new PeepSoGroup($group_id);
            $user_id = get_current_user_id();
            self::badgeos_peepso_trigger_event($user_id, current_filter());
        }
    }

    /**
     * Function called after checkout membership
     * @param user_id
     * @param dest_file
     */
    public static function action_pmp_checkout($user_id, $morder)
    {
        if(0 !== $user_id && !empty($morder->membership_id) ){
            $args['peepso_pmp_level_id'] = $morder->membership_id;
            self::badgeos_peepso_trigger_event($user_id, current_filter(), $args);
        }
    }

    /**
     * Handle each of our peepso triggers
     *
     * @since 1.0.0
     */
    public static function badgeos_peepso_trigger_event( $user_ID, $this_trigger, $args = array() ) {
        global $wpdb;

        $blog_id = get_current_blog_id();

        $user_data = get_user_by( 'id', $user_ID );

        // check if badgeos integration enable
        if( !PeepSo::get_option('badgeos_integration_enable', 1) ) {
            return ;
        }

        // Sanity check, if we don't have a user object, bail here
        if ( ! is_object( $user_data ) ) {
            return ;
        }

        add_filter('badgeos_dependent_achievements', array('BadgeOS_PeepSoTriggers', 'badgeos_peepso_dependent_achievements'), 10, 2);

        // Update hook count for this user
        $new_count = badgeos_update_user_trigger_count( $user_ID, $this_trigger, $blog_id );

        // Mark the count in the log entry
        badgeos_post_log_entry( null, $user_ID, null, sprintf( __( '%1$s triggered %2$s (%3$dx)', 'badgeos-peepso' ), $user_data->user_login, $this_trigger, $new_count ) );

        // Now determine if any badges are earned based on this trigger event
        $triggered_achievements = $wpdb->get_results( $wpdb->prepare(
            "
            SELECT post_id
            FROM   $wpdb->postmeta
            WHERE  meta_key = '_badgeos_peepso_trigger'
                   AND meta_value = %s
            ",
            $this_trigger
        ) );
        foreach ( $triggered_achievements as $achievement ) {
            # Since we are triggering multiple times based on group joining, we need to check if we're on the peepso_action_group_user_join filter.
            if ( 'peepso_action_group_user_join' == current_filter() ) {
                # We only want to trigger this when we're checking for the appropriate triggered group ID.
                $group_id = get_post_meta( $achievement->post_id, '_badgeos_peepso_group_id', true );
                if ( $group_id == $args['peepso_group_id'] ) {
		            badgeos_maybe_award_achievement_to_user( $achievement->post_id, $user_ID, $this_trigger, $blog_id, $args );
		        }
            # Since we are triggering multiple times based on membership checkkout, we need to check if we're on the peepso_action_pmp_checkout filter.
            } elseif( 'peepso_action_pmp_checkout' == current_filter() ) {
                # We only want to trigger this when we're checking for the appropriate triggered group ID.
                $pmp_level_id = get_post_meta( $achievement->post_id, '_badgeos_peepso_pmp_level_id', true );
                if ( $pmp_level_id == $args['peepso_pmp_level_id'] ) {
                    badgeos_maybe_award_achievement_to_user( $achievement->post_id, $user_ID, $this_trigger, $blog_id, $args );
                }
            } else {
                badgeos_maybe_award_achievement_to_user( $achievement->post_id, $user_ID, $this_trigger, $blog_id, $args );
    		}
        }
    }

    public static function badgeos_peepso_dependent_achievements($lists, $achievement_id) {
        $type = badgeos_utilities::get_post_type($achievement_id);

        if ($type !== 'step') {
            $new_lists = [];

            foreach ($lists as $list) {
                if (in_array($list->ID, $GLOBALS['badgeos']->award_ids)) {
                    $new_lists[] = $list;
                }
            }

            $lists = $new_lists;
        }

        return $lists;
    }
}