import $ from 'jquery';
import { observer } from 'peepso';
import { ajaxurl } from 'peepsodata';
import './page-classifieds';

// Handle send message.
$(function () {
	$(document).on('click', '.ps-js-wpadverts-message', function (e) {
		let $btn = $(e.currentTarget),
			id = $btn.data('id'),
			postId = $btn.data('post-id');

		e.preventDefault();
		e.stopPropagation();

		if (window.ps_messages) {
			ps_messages.new_message(id, false, $btn[0], { wpadverts: postId });
		}
	});

	$(document).on('click', '.ps-js-wpadverts-attachment-remove', function (e) {
		e.preventDefault();
		e.stopPropagation();

		let $el = $(e.currentTarget);
		let $window = $el.closest('.ps-js-chat-window[data-id]');
		if ($window) {
			observer.doAction('pschat_remove_attachment', $window.data('id'));
		}
	});

	function getAdInfo(id) {
		return $.ajax({
			type: 'POST',
			url: ajaxurl,
			data: { action: 'peepso_wpadverts_ad_info', id },
			dataType: 'json'
		});
	}

	observer.addFilter(
		'pschat_input',
		function (res, opts) {
			if ('object' === typeof opts && opts.wpadverts) {
				let timestamp = new Date().getTime();
				res.attachment = `<div class="ps-chat__window-input ps-js-wpadverts-attachment-${timestamp}"
					data-id="${opts.wpadverts}" style="height:auto">loading&hellip;</div>`;

				getAdInfo(opts.wpadverts).done(json => {
					let $el = $(`.ps-js-wpadverts-attachment-${timestamp}`);
					if (json && json.html_chat) {
						$el.html(json.html_chat).show();
					} else {
						$el.hide();
					}
				});
			}

			return res;
		},
		10,
		2
	);

	observer.addAction(
		'new_message_dialog',
		function (elem, conf = {}) {
			let { postbox: $postbox, opts } = conf;

			if ('object' === typeof opts && opts.wpadverts) {
				let timestamp = new Date().getTime();
				let attachment = `<div data-attachment class="ps-js-wpadverts-attachment-${timestamp}"
					data-id="${opts.wpadverts}" style="height:auto; margin-bottom:var(--text-padd);">loading&hellip;</div>`;

				let $container = $postbox.$textarea.closest('.ps-postbox-input');
				$container.prepend(attachment);
				$container.off('click.ps-remove-attachment');
				$container.on(
					'click.ps-remove-attachment',
					'.ps-js-wpadverts-attachment-remove',
					function (e) {
						e.preventDefault();
						e.stopPropagation();
						$(e.currentTarget).closest('[data-attachment]').remove();
						observer.doAction('new_message_dialog_remove_attachment', $container);
					}
				);

				getAdInfo(opts.wpadverts).done(json => {
					let $el = $(`.ps-js-wpadverts-attachment-${timestamp}`);
					if (json && json.html_message) {
						$el.html(json.html_message).show();
					} else {
						$el.hide();
					}
				});
			}
		},
		10,
		2
	);
});
