<?php adverts_flash( $adverts_flash ) ?>

<div class="ps-page ps-page--wpadverts ps-page--wpadverts-edit">
    <form action="" method="post" class="ps-form ps-wpadverts__edit-form">
      <div class="ps-form__grid">
        <?php foreach($form->get_fields( array( "type" => array( "adverts_field_hidden" ) ) ) as $field): ?>
        <?php call_user_func( adverts_field_get_renderer($field), $field, $form) ?>
        <?php endforeach; ?>

        <?php foreach($form->get_fields( array( "exclude" => array( "account" ) ) ) as $field): ?>

            <?php if($field["type"] == "adverts_field_header"): ?>
                <div class="ps-form__legend">
                  <?php echo esc_html($field["label"]) ?>
                  <?php if( isset( $field["description"] ) ): ?>
                      <div class="ps-form__legend-desc"><?php echo esc_html( $field["description"] ) ?></div>
                  <?php endif; ?>
                </div>
            <?php else: ?>

            <div class="ps-form__row <?php echo "ps-form__row-" . esc_attr( str_replace("_", "--", $field["name"] )) ?> <?php if(adverts_field_has_errors($field)): ?>ps-form__row--error<?php endif; ?>">

                <label class="ps-form__label" for="<?php echo __($field["name"]) ?>">
                    <?php esc_html_e($field["label"]) ?>
                    <?php if(adverts_field_has_validator($field, "is_required")): ?>
                        <span class="ps-text--danger">*</span>
                    <?php endif; ?>
                </label>

                <div class="ps-form__field">
                    <?php call_user_func( adverts_field_get_renderer($field), $field, $form) ?>

                    <?php if(adverts_field_has_errors($field)): ?>
                        <div class="ps-form__helper ps-text--danger">
                        <?php foreach($field["error"] as $k => $v): ?>
                            <div class="ps-form__error"><?php echo esc_html($v) ?></div>
                        <?php endforeach; ?>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
            <?php endif; ?>

        <?php endforeach; ?>
        <div class="ps-form__row ps-form__row--submit">
          <a href="<?php echo __($baseurl) ?>" class="ps-btn ps-btn--sm"><?php echo __("Go back", "peepso-wpadverts") ?></a>
          <div class="ps-btn__group">
            <a href="<?php echo __(get_post_permalink( $post_id )) ?>" class="ps-btn ps-btn--sm"><?php echo __("Preview", "peepso-wpadverts") ?></a>
            <input type="submit" name="submit" value="<?php echo __("Update", "peepso-wpadverts") ?>" class="ps-btn ps-btn--sm ps-btn--action" />
          </div>
        </div>
      </div>
    </form>
</div>
