<div class="ps-classifieds ps-classifieds--manage">
    <?php if( $loop->have_posts()): ?>
    <?php while ( $loop->have_posts() ) : $loop->the_post(); ?>
    <?php global $post ?>

    <div class="ps-classified advert-manage-item <?php if(! $post->menu_order < 1): ?>ps-classified--featured<?php endif; ?>">
        <div class="ps-classified__inner ps-classified__item--manage">
            <?php $image = get_the_post_thumbnail_url( get_the_ID(), 'full' ) ?>

            <?php if($image): ?>
            <div class="ps-classified__photo">
              <a class="ps-classified__photo-link" href="<?php the_permalink() ?>" style="background-image:url('<?php echo esc_attr($image) ?>');">
                <img src="<?php echo esc_attr($image) ?>" alt="">
              </a>
            </div>
            <?php endif; ?>

            <div class="ps-classified__body">
              <a class="ps-classified__title" href="<?php the_permalink() ?>"><?php the_title() ?></a>

              <div class="ps-classified__content">
                <?php if($post->post_status == "pending"): ?>
                <span class="ps-alert ps-alert--warning"><?php echo __("Inactive — This Ad is in moderation.", "peepso-wpadverts") ?></span>
                <?php endif; ?>

                <?php if($post->post_status == "expired"): ?>
                <span class="ps-alert ps-alert--warning"><?php echo __("Inactive — This Ad expired.", "peepso-wpadverts") ?></span>
                <?php endif; ?>
              </div>

              <div class="ps-classified__meta-wrapper">
                <?php do_action("adverts_sh_manage_list_status", $post) ?>

                <?php $expires = get_post_meta( $post->ID, "_expiration_date", true ) ?>
                <?php if( $expires ): ?>
                <span class="ps-classified__meta ps-classified__meta-status"><i class="gcis gci-history"></i><?php echo esc_html( sprintf( __( "Expires: %s", "peepso-wpadverts" ), date_i18n( get_option("date_format"), $expires ) ) ) ?></span>
                <?php endif; ?>
              </div>

              <div class="ps-classified__actions">
                <?php $price = get_post_meta( get_the_ID(), "adverts_price", true ) ?>
                <?php if( $price ): ?>
                <div class="ps-classified__price">
                  <a href="<?php the_permalink() ?>"><?php echo adverts_price( $price ) ?></a>
                </div>
                <?php endif; ?>

                <div class="ps-classified__actions-inner">
                    <!--<a href="<?php echo __(get_the_permalink()) ?>" title="<?php echo __("View", "peepso-wpadverts") ?>"><i class="ps-icon-eye"></i> <?php echo __("View", "peepso-wpadverts") ?></a>-->
                    <a href="<?php echo esc_attr(adverts_ajax_url()) ?>?action=adverts_delete&id=<?php echo get_the_ID() ?>&redirect_to=<?php echo __( urlencode( $baseurl ) ) ?>&_ajax_nonce=<?php echo wp_create_nonce( sprintf( 'wpadverts-delete-%d', get_the_ID() ) ) ?>" title="<?php echo __("Delete", "wpadverts") ?>" class="ps-classified__action ps-btn ps-btn--sm ps-btn--cp ps-btn--app ps-tip adverts-manage-action-delete" data-id="<?php echo get_the_ID() ?>" data-nonce="<?php echo wp_create_nonce( sprintf( 'wpadverts-delete-%d', get_the_ID() ) ) ?>" aria-label="<?php echo __("Delete", "peepso-wpadverts") ?>">
                      <i class="gcis gci-trash-alt"></i>
                    </a>

                    <a class="ps-classified__action ps-btn ps-btn--sm ps-btn--cp ps-btn--app" href="<?php echo __($baseurl . str_replace("%#%", get_the_ID(), $edit_format)) ?>">
                      <i class="gcis gci-pencil-alt"></i> <?php echo __("Edit", "peepso-wpadverts") ?>
                    </a>

                    <div class="ps-classified__delete-box adverts-manage-delete-confirm" style="display:none">
                      <div class="ps-classified__delete-box-inner">
                        <div class="ps-classified__delete-box-notice">
                          <i class="gcis gci-trash-alt"></i>
                					<!-- <i class="ps-icon-spinner" style="display:none"></i> -->
                					<?php echo __('Are you sure?', 'peepso-wpadverts'); ?>
                        </div>
              					<a href="#" class="ps-btn ps-btn--sm ps-btn--action ps-js-delete-yes adverts-manage-action-delete-yes" onclick="return false;"><?php echo __('Yes', 'peepso-wpadverts'); ?></a>
              					<a href="#" class="ps-btn ps-btn--sm ps-js-delete-no adverts-manage-action-delete-no" onclick="return false;"><?php echo __('Cancel', 'peepso-wpadverts'); ?></a>
                      </div>
                    </div>

                    <!-- <a href="#" class="adverts-manage-action-more"><span class="adverts-icon-menu"></span><?php echo __("More", "adverts") ?></a> -->

                    <?php do_action( "adverts_sh_manage_actions_right", $post->ID, $baseurl ) ?>
                    <?php do_action( "adverts_sh_manage_actions_left", $post->ID, $baseurl ) ?>
                    <?php do_action( "adverts_sh_manage_actions_more", $post->ID, $baseurl ) ?>
                </div>
                <?php do_action( "adverts_sh_manage_actions_after", $post->ID, $baseurl ) ?>
              </div>
            </div>
        </div>
    </div>

    <?php endwhile; ?>
    <?php else: ?>
    <div class="ps-alert ps-alert--neutral">
        <?php echo __("You do not have any Ads posted yet.", "adverts") ?>
    </div>
    <?php endif; ?>
    <?php wp_reset_query(); ?>
</div>

<div class="adverts-pagination">
    <?php echo paginate_links( array(
        'base' => $paginate_base,
    'format' => $paginate_format,
    'current' => max( 1, $paged ),
    'total' => $loop->max_num_pages,
        'prev_next' => false
    ) ); ?>
</div>
