<div class="peepso">
	<?php
	if (get_current_user_id() || PeepSo::get_option('wpadverts_allow_guest_access_to_classifieds', 0) === 1) { ?>
	<div class="ps-page ps-page--wpadverts">
		<?php
		PeepSoTemplate::exec_template('general','navbar');

		if (PeepSo::get_option('wpadverts_allow_guest_access_to_classifieds', 0) === 0) {
			PeepSoTemplate::exec_template('general', 'register-panel');
		}

		?>
		<div class="ps-wpadverts">
			<form class="ps-form" role="form" name="form-peepso-search" onsubmit="return false;">
				<div class="ps-wpadverts__header">
					<div class="ps-wpadverts__header-inner">
						<div class="ps-wpadverts__search">
							<div class="ps-form__row">
								<div class="ps-form__field ps-form__field--icon">
									<input placeholder="<?php echo __('Start typing to search...', 'peepso-wpadverts');?>" type="text" class="ps-input ps-input--sm ps-input--icon ps-input--icon-right ps-js-classifieds-query" name="query" value="<?php echo esc_attr($search); ?>" />
									<a href="#" class="ps-input__icon ps-input__icon--right ps-wpadverts__filters-toggle ps-tooltip ps-form-search-opt" onclick="return false;" data-tooltip="<?php echo __('Show filters', 'peepso-wpadverts');?>">
										<i class="gcis gci-cog"></i>
									</a>
								</div>
							</div>
						</div>

						<div class="ps-wpadverts__actions">
							<a class="ps-btn ps-btn--sm ps-btn--action" href="<?php echo PeepSo::get_page('wpadverts') . (PeepSo::get_option('disable_questionmark_urls', 0) === 0 ? '?' : '') . 'create/';?>">
								<?php echo __('Create', 'peepso-wpadverts');?>
							</a>
						</div>
					</div>

					<?php
					$default_sorting = '';
					if(!strlen(esc_attr($search)))
					{
						$default_sorting = PeepSo::get_option('classifieds_default_sorting','id');
					}

					$location_input_type = '';
					$show_radius = false;

					if (class_exists('WPAdverts_Mal_Search')) {
						$_type = adverts_config('mal.adverts_list_location_input');

						if (false !== strpos($_type, 'replace-location-with-')) {
							$location_input_type = str_replace('replace-location-with-', '', $_type);
							$show_radius = adverts_config('mal.adverts_list_show_radius') == '1';

							// Load Google Maps API script from the "WP Adverts - Maps and Locations" plugin.
							if ('google-places' === $location_input_type) {
								wp_enqueue_script('wpadverts-mal-google-api');
							}
						}
					}

					?>
					<div class="ps-wpadverts__filters ps-js-page-filters">
						<div class="ps-wpadverts__filters-inner">
							<div class="ps-wpadverts__filter">
								<label class="ps-wpadverts__filter-label"><?php echo __('Location', 'peepso-wpadverts'); ?></label>
								<input type="text" name="location" class="ps-input ps-input--sm ps-js-classifieds-location"
									value="<?php echo esc_attr($location); ?>"
									data-type="<?php echo esc_attr($location_input_type); ?>"
									placeholder="<?php echo __('Start typing to search...', 'peepso-wpadverts');?>" />
							</div>

							<?php if ($show_radius) { ?>
							<div class="ps-wpadverts__filter">
								<label class="ps-wpadverts__filter-label"><?php echo __('Radius', 'peepso-wpadverts'); ?></label>
								<select name="radius" class="ps-input ps-input--sm ps-input--select ps-js-classifieds-radius"><?php
									$du = adverts_config('mal.distance_unit');
									$radius_options = array(
										array('value' => '', 'text' => __('Radius', 'peepso-wpadverts')),
										array('value' => '5', 'text' => sprintf('5 %s', $du)),
										array('value' => '10', 'text' => sprintf('10 %s', $du)),
										array('value' => '25', 'text' => sprintf('25 %s', $du)),
										array('value' => '50', 'text' => sprintf('50 %s', $du))
									);

									foreach ($radius_options as $option) {
										echo '<option value="' . $option['value'] . '">' . $option['text']  . '</option>';
									}

								?></select>
							</div>
							<?php } ?>

							<?php if($adverts_categories) { ?>
								<div class="ps-wpadverts__filter">
									<label class="ps-wpadverts__filter-label"><?php echo __('Category', 'peepso-wpadverts'); ?></label>
									<select class="ps-input ps-input--sm ps-input--select ps-js-classifieds-category">
										<option value="0"><?php echo __('All categories', 'peepso-wpadverts'); ?></option>
										<?php
										if(count($adverts_categories)) {
											$PeepSoInput = new PeepSoInput();
											$category = $PeepSoInput->int('category', 0);
											foreach($adverts_categories as $id=>$cat) {
												$selected = "";
												if($cat['value']==$category) {
													$selected = ' selected="selected"';
												}
												echo "<option value=\"{$cat['value']}\"{$selected}>".str_repeat(' - ', $cat['depth'])."{$cat['text']}</option>";
											}
										}
										?>
									</select>
								</div>
							<?php } // ENDIF ?>
						</div>
					</div>
				</div>
			</form>

			<div class="ps-wpadverts__tabs">
				<div class="ps-wpadverts__tabs-inner">
					<div class="ps-wpadverts__tab ps-wpadverts__tab--active"><a href="<?php echo PeepSo::get_page('wpadverts');?>"><?php echo __('Classifieds', 'peepso-wpadverts'); ?></a></div>
					<div class="ps-wpadverts__tab"><a href="<?php echo PeepSo::get_page('wpadverts').'?category/';?>"><?php echo __('Classifieds Categories', 'peepso-wpadverts'); ?></a></div>
				</div>
			</div>

			<?php
			// Get columns number from WPAdverts config

			$columns = "";

			if (class_exists('Adverts')) {
				if (PeepSo::get_option('wpadverts_display_ads_as') == "2") { // if Grid view selected
					$columns = 'ps-classifieds__grid ps-classifieds__grid--' . adverts_config( 'config.ads_list_default__columns' );
				}
			}
			?>

			<div class="mb-20"></div>
			<div class="ps-classifieds <?php echo $columns; ?> ps-js-classifieds"></div>
			<div class="ps-classifieds__loading ps-js-classifieds-triggerscroll">
				<img class="ps-loading post-ajax-loader ps-js-classifieds-loading" src="<?php echo PeepSo::get_asset('images/ajax-loader.gif'); ?>" alt="" />
			</div>
		</div>
	</div>
	<?php } ?>
</div>
<?php

if(get_current_user_id()) {
	PeepSoTemplate::exec_template('activity', 'dialogs');
}
