<?php

$target = 'target="_blank"';

$image_url = NULL;

if($image = wp_get_attachment_image_src( $ad->output['image_id'], 'full' )) {
    $image_url = $image[0];
}

$avatar_url = "";

if($avatar = wp_get_attachment_image_src( $ad->output['avatar_id'], 'full' )) {
    $avatar_url = $avatar[0];
}

$url = ( isset( $ad->url ) ) ? esc_url( $ad->url ) : '#';

$title = $ad->title;
if(isset($ad->output['title_override']) && strlen($ad->output['title_override'])) {
    $title = $ad->output['title_override'];
}
?>
<!-- <div class="ps-post ps-advads__post ps-js-activity"> -->
    <div class="ps-post__header">
      <?php if($avatar_url) { ?>
        <a class="ps-avatar ps-avatar--post" <?php echo $target;?>  href="<?php echo $url;?>">
          <img src="<?php echo $avatar_url;?>" />
        </a>
      <?php } ?>

      <div class="ps-post__meta">
        <div class="ps-post__title">
          <a <?php echo $target;?> href="<?php echo $url;?>">
            <?php echo $title;?>
          </a>
        </div>
        <div class="ps-post__info">
          <?php if(PeepSo::get_option('advancedads_stream_sponsored_mark', 0)) {
              echo PeepSo::get_option('advancedads_stream_sponsored_text');
          }
          ?>
        </div>
      </div>
    </div>

    <div class="ps-post__body">
      <div class="ps-post__content">
        <?php 
            if (PeepSo::get_option_new('advanced_ads_allow_all_tags')) {
              echo $ad->content;
            } else {
              echo wpautop(strip_tags($ad->content, PeepSoAdvancedAdsAdTypePeepSo::get_allowed_html()));
            }
        ?>
      </div>

      <?php if($image_url) { ?>
      <a <?php echo $target;?> class="ps-advads__image" href="<?php echo $url;?>">
        <img src="<?php echo $image_url;?>" />
      </a>
      <?php } ?>
    </div>
<!-- </div> -->
