jQuery(function ($) {
	var url = new URL(location.href);
	var params = url.searchParams;

	if (params.get('page') == 'peepso-social-login' || (params.get('page') == 'peepso-manage' && params.get('tab') == 'slai')) {
		$('.nav-tab-wrapper a').on('click', function () {
			var tab = $(this).attr('data-page');
			window.history.replaceState(
				null,
				null,
				socialloginadmin.adminurl + 'admin.php?page=peepso-social-login&tab=' + tab
			);

			$('#social-login-form').attr('action', window.location.href);
		});

		$('.show-info').on('click', function (e, mode) {
			var $button = $(this).closest('.show-info'),
				$label = $button.find('[data-label-show]'),
				$info = $button.closest('.tp-social-login').find('.info'),
				hidden = $info.hasClass('slide-up');

			e.preventDefault();

			// Override state if second parameter is provided.
			if (['show', 'hide'].indexOf(mode) >= 0) {
				hidden = mode === 'show';
			}

			if (hidden) {
				$info.removeClass('slide-up').addClass('slide-down');
				$label.html($label.data('label-hide'));
			} else if (!hidden) {
				$info.removeClass('slide-down').addClass('slide-up');
				$label.html($label.data('label-show'));
			}
		});

		$('input[type=checkbox]')
			.filter('[name$="[enabled]"]')
			.on('change', function (e, mode) {
				var $checkbox = $(this),
					$siblings = $checkbox.closest('tr').nextAll('tr'),
					$parent = $checkbox.closest('.tp-social-login'),
					$toggleInfo = $parent.find('.show-info');

				if (this.checked) {
					$siblings.removeClass('hide');
					$parent.removeClass('disabled').addClass('enabled');
					if (mode !== 'init') {
						$toggleInfo.triggerHandler('click', 'show');
					}
					$checkbox.closest('.postbox').removeClass('postbox-muted');
				} else {
					$siblings.addClass('hide');
					$parent.removeClass('enabled').addClass('disabled');
					if (mode !== 'init') {
						$toggleInfo.triggerHandler('click', 'hide');
					}
					$checkbox.closest('.postbox').addClass('postbox-muted');
				}
			})
			.triggerHandler('change', 'init');

		$('.nav-tab').on('click', function () {
			$('.nav-tab').removeClass('nav-tab-active');
			$(this).addClass('nav-tab-active');

			$('.page-tab').hide();
			$('.' + $(this).attr('data-page')).show();
		});

		var $color_picker = $('.color-picker');

		$color_picker.each(function (index, el) {
			var $el = $(el);
			var color = $el.val();
			var $icon = $el.closest('.tp-providers').siblings('.tp-postbox__title').find('.tsc-icon');
			var options = [];
			var providers = $el.closest('.tp-providers').data('id');

			if ($el.hasClass('icon-color')) {
				options['defaultColor'] = options['color'] = socialloginadmin.default_colors[providers]['icon-color'];

				if (color != '') {
					$icon.css('color', color);
					options['color'] = color;
				}
			} else if ($el.hasClass('background-color')) {
				var $container = $el.closest('.tp-providers').siblings('.tp-postbox__title');
				var is_disabled = 0;

				if ($container.hasClass('disabled')) {
					is_disabled = 1;
					$container.removeClass('disabled');
				}	

				options['defaultColor'] = socialloginadmin.default_colors[providers]['background-color'];

				if (color != '') {
					$icon.css('background-color', color);
					options['color'] = color;
				}

				$icon.css('opacity',1);

				if (is_disabled) {
					$container.addClass('disabled');
				}
			}

			$el.val(options['color']);
			$el.wpColorPicker(options);
		});

		$color_picker.wpColorPicker({
			change: function (event, ui) {
				var $icon = $(this).closest('.tp-providers').siblings('.tp-postbox__title').find('.tsc-icon');
				var $el = $(this);

				setTimeout(function () {
					var color = $el.val();

					if ($el.hasClass('icon-color')) {
						$icon.css('color', color);
					} else if ($el.hasClass('background-color')) {
						$icon.css('background-color', color);
					}
				}, 1);

			}
		});


		// drag and drop
		var $container = $('.tp-providers-container');

		$container.on('input', '.ps-providers-notification', function () {
			$(this)
				.closest('.tp-providersconf')
				.find('.ps-providers-hint-inner')
				.html($(this).val());
		});

		// drag n' drop functionality
		$container.sortable({
			handle: '.tp-handle',
			// Fix accidentally firing click event after sorting.
			// https://stackoverflow.com/questions/947195/jquery-ui-sortable-how-can-i-cancel-the-click-event-on-an-item-thats-dragged
			helper: 'clone',
			update: _.throttle(function () {
				var id = [];
				$('.tp-providers-container .postbox').each(function () {
					id.push($(this).data('id'));
				});

				$.post(socialloginadmin.ajaxurl, {
					action: 'social_login_reorder',
					prop: 'box_status',
					id: JSON.stringify(id),
					status: status
				}, function (response) {
				});
			}, 3000)
		});

		// toggle a providers
		$container.on('click', '.tp-providers-toggle', function () {
			var $btn = $(this),
				$el = $btn.closest('.postbox'),
				$providers = $el.find('.tp-providers'),
				id = $el.data('id');

			if ($providers.is(':visible')) {
				$providers.slideUp('fast', function () {
					$btn.removeClass('tfa-compress').addClass('tfa-expand');
					updateToggleAllButton();
					updateprovidersVisibility(id, 0);
				});
			} else {
				$providers.slideDown('fast', function () {
					$btn.removeClass('tfa-expand').addClass('tfa-compress');
					updateToggleAllButton();
					updateprovidersVisibility(id, 1);
				});
			}
		});

		// toggle a providers when clicking the top bar
		$container.on('click', '.tp-providers-title', function (e) {
			e.preventDefault();
			$(this).closest('.tp-postbox__title').find('.tp-providers-toggle').click();
		});

		// toggle drag-n-drop cursor
		var mousedownTimer;
		$container
			.on('mousedown', '.tp-postbox__title', function (e) {
				var $this = $(e.currentTarget);
				mousedownTimer = setTimeout(function () {
					$this.addClass('tp-mousedown');
				}, 200);
			})
			.on('mouseup mouseleave', '.tp-postbox__title', function (e) {
				clearTimeout(mousedownTimer);
				$(e.currentTarget).removeClass('tp-mousedown');
			});

		// toggle expand all providerss
		$('.tp-providers-expand-all').on('click', function () {
			$container.find('.tp-providers').slideDown('fast', function () {
				toggleAllCallback(1);
			});
		});

		// toggle collapse all providerss
		$('.tp-providers-collapse-all').on('click', function () {
			$container.find('.tp-providers').slideUp('fast', function () {
				toggleAllCallback(0);
			});
		});

		var toggleAllCallback = _.debounce(function (status) {
			var $providers = $('.tp-providers-container').children('.postbox');

			if (status === 0) {
				$providers
					.find('.tp-providers-toggle')
					.removeClass('fa-compress')
					.addClass('fa-expand');
			} else {
				$providers
					.find('.tp-providers-toggle')
					.removeClass('fa-expand')
					.addClass('fa-compress');
			}

			updateToggleAllButton(status);
			updateprovidersVisibility('all', status);
		}, 200);

		function updateToggleAllButton(status) {
			var $btn = $('.tp-providers-toggle-all'),
				$icon = $btn.find('span').first(),
				$label = $btn.find('span').last(),
				len,
				visible;

			if (typeof status === 'undefined') {
				len = 0;
				visible = 0;
				status = 0;
				$('.tp-providers-container')
					.find('.tp-providers')
					.each(function () {
						len++;
						if ($(this).is(':visible')) {
							visible++;
						}
					});
				if (visible >= len) {
					status = 1;
				}
			}

			if (+status === 0) {
				$btn.data('status', 0);
				$label.html($btn.data('expand-text'));
				$icon.removeClass('fa-compress').addClass('fa-expand');
			} else {
				$btn.data('status', 1);
				$label.html($btn.data('collapse-text'));
				$icon.removeClass('fa-expand').addClass('fa-compress');
			}
		}

		// check button on page-load
		updateToggleAllButton();

		var updateprovidersXHR = {};
		var updateprovidersVisibility = _.debounce(function (id, status) {
			var ids = [];
			if (id !== 'all') {
				ids = [id];
			} else {
				$('.tp-providers-container')
					.children('.postbox')
					.each(function () {
						ids.push($(this).data('id'));
					});
			}

			updateprovidersXHR[id] &&
				updateprovidersXHR[id].ret &&
				updateprovidersXHR[id].ret.abort();
			updateprovidersXHR[id] = $.post(socialloginadmin.ajaxurl, {
				action: 'social_login_update',
				prop: 'box_status',
				id: JSON.stringify(ids),
				status: status,
				_wpnonce: socialloginadmin.update_nonce
			}, function (response) {
			});
		}, 500);

		// float-bar
		$(function () {
			var bar = $('.tp-settings__bar--float');
			bar.addClass('tp-settings__bar--static');

			$(window).on('scroll', function () {
				var bar = $('.tp-settings__bar--float');
				var scrollVal = $(this).scrollTop();
				if (scrollVal > 50) {
					bar.removeClass('tp-settings__bar--static');
				} else {
					bar.addClass('tp-settings__bar--static');
				}
			});
		});
	}

	$(document).on('click', '#social-login-notice-dismiss', function () {
		var type = $(this).attr('data-type');
		var elem = $(this).closest('div');
		$.post(ajaxurl, { action: 'dismiss_' + type }, function (response) {
			elem.slideUp();
		});
	});
});
