( function( wp ) {
	var __ = wp.i18n.__,
		el = wp.element.createElement,
		registerBlockType = wp.blocks.registerBlockType,
		ServerSideRender = wp.components.ServerSideRender,
		InspectorControls = wp.editor.InspectorControls,
		PanelBody = wp.components.PanelBody,
		TextControl = wp.components.TextControl;

	// Sample options. You can assign options value from a wp_localize_script variable, e.g:
	registerBlockType( 'social-login/social-login', {
		title: sociallogin.plugin_name,
		icon: 'facebook',
		category: 'common',

		attributes: {
			link: {
				type: 'string',
				default: sociallogin.site_url
			}
		},

		edit: function( props ) {
			var attributes = props.attributes;

			function onLinkChange( value ) {
				props.setAttributes( { link: value } );
			}

			var productDropdown = el(
				PanelBody,
				{ title: __( 'Options', 'social-login' ) },
				el( TextControl, {
					label: __( 'Link', 'social-login' ),
					value: attributes.link,
					onChange: onLinkChange
				} ),
			);

			return [
				el( InspectorControls, null, productDropdown ),
				el( ServerSideRender, {
					block: 'social-login/social-login',
					attributes: props.attributes
				} )
			];
		},

		save: function( props ) {
			//gutenberg will save attributes we can use in server-side callback
			return null;
		}
	} );
} )( window.wp );
