<?php

class Social_Login_Admin_Config {

    public static function index() {
        $social_login_fields = [
            'first_name',
            'last_name',
            'birthdate'
        ];

        if (isset($_POST['social-login-nonce']) && wp_verify_nonce($_POST['social-login-nonce'], 'form-action')) {
            $option = [];
            $i = 0;
            $enabled = 0;
            foreach (PeepSoSocialLoginPlugin::get_provider_option() as $key => $value) {
                if (!$enabled && isset($_POST[$key]['enabled'])) {
                    $enabled = 1;
                }

                $option['providers'][$key] = array_filter(array_map('trim', $_POST[$key]));
                array_walk($option['providers'][$key], 'sanitize_text_field');
                $option['providers'][$key]['order'] = $i;
                $i++;
            }

            update_option(PeepSoSocialLoginPlugin::OPTION_HAS_PROVIDER, $enabled);


            if (class_exists('PeepSo')) {
                $option['import_avatar'] = (int) $_POST['import_avatar'];
                $option['enable_peepso_integration'] = (int) $_POST['enable_peepso_integration'];
                $option['admin_verification'] = isset($_POST['admin_verification']) ? (int) $_POST['admin_verification'] : 0;

                foreach ($social_login_fields as $field) {
                    if (isset($_POST['field_' . $field])) {
                        $option['peepso_field_mapping'][$field] = (int) $_POST['field_' . $field];
                    }  else {
                        $option['peepso_field_mapping'][$field] = 0;
                    }
                }
            }

            Social_Login_Helper::set_notice('success', __('Configuration saved', 'social-login'));
            update_option(PeepSoSocialLoginPlugin::OPTION, $option);
        } else {
            $option = get_option(PeepSoSocialLoginPlugin::OPTION);
        }

        $data = [
            'title' => __('Social Login by PeepSo', 'social-login'),
            'providers' => PeepSoSocialLoginPlugin::get_provider_option(),
            'option' => $option,
            'pages' => get_pages([
                'sort_column' => 'post_title'
            ]),
            'social_login_fields' => $social_login_fields
        ];

        if (class_exists('PeepSo')) {
            $PeepSoUser = PeepSoUser::get_instance(0);
            $profile_fields = new PeepSoProfileFields($PeepSoUser);
            $data['fields'] = $profile_fields->load_fields();
        }

        echo esc_html(Social_Login_Template::exec_template('admin', 'config', $data));
    }

}