<?php

class PeepSoConfigSectionSLAI extends PeepSoConfigSectionAbstract
{
// Builds the groups array
    public function register_config_groups()
    {
        $this->context='left';
        $this->peepso();
    }

    private function peepso(){

        $this->set_field(
            'slai_enabled',
            __('Enabled','social-login'),
            'yesno_switch'
        );


        $this->set_field(
            'slai_avatars',
            __('Import avatars','social-login'),
            'yesno_switch'
        );

        // Profile field mapping
        $PeepSoUser = PeepSoUser::get_instance(0);
        $profile_fields = new PeepSoProfileFields($PeepSoUser);
        $fields = $profile_fields->load_fields();

        $options = [0=>__("-- Select field --", 'social-login') ];
        foreach($fields as $field){
            $options[$field->id] = $field->title;
        }

        $this->args('options', $options);
        $this->set_field(
            'slai_field_first',
            __('First name','social-login'),
            'select'
        );

        $this->args('options', $options);
        $this->set_field(
            'slai_field_last',
            __('Last name','social-login'),
            'select'
        );

        $this->args('options', $options);
        $this->set_field(
            'slai_field_bday',
            __('Birthdate','social-login'),
            'select'
        );


        $this->set_group(
            'peepso',
            __('General', 'social-login')
        );
    }



}