<?php

class Social_Login_New_Admin_Config {

    public static function index() {
        $social_login_fields = [
            'first_name',
            'last_name',
            'birthdate'
        ];

        if (isset($_POST['social-login-nonce']) && wp_verify_nonce($_POST['social-login-nonce'], 'form-action')) {
            $option = [];
            $i = 0;
            $enabled = 0;
            foreach (PeepSoSocialLoginPlugin::get_provider_option() as $key => $value) {
                if (!$enabled && isset($_POST[$key]['enabled'])) {
                    $enabled = 1;
                }

                $option['providers'][$key] = array_filter(array_map('trim', $_POST[$key]));
                array_walk($option['providers'][$key], 'sanitize_text_field');
                $option['providers'][$key]['order'] = $i;
                $i++;
            }

            update_option(PeepSoSocialLoginPlugin::OPTION_HAS_PROVIDER, $enabled);

            Social_Login_Helper::set_notice('success', __('Configuration saved', 'social-login'));
            update_option(PeepSoSocialLoginPlugin::OPTION, $option);
        } else {
            $option = get_option(PeepSoSocialLoginPlugin::OPTION);
        }

        $data = [
            'providers' => PeepSoSocialLoginPlugin::get_provider_option(),
            'option' => $option,
            'pages' => get_pages([
                'sort_column' => 'post_title'
            ]),
            'social_login_fields' => $social_login_fields
        ];

        echo esc_html(Social_Login_Template::exec_template('admin', 'new_config', $data));
    }

}