<?php

Class Social_Login_Helper {

    public static function redirect($url) {
        echo '<script>window.location.href="' . esc_url($url) . '"</script>';
    }

    public static function set_notice($type, $message) {
        @session_start();
        $_SESSION['_notice_type'] = $type;
        $_SESSION['_notice_message'] = $message;
    }

    public static function check_notice($print = FALSE) {
        @session_start();
        if (isset($_SESSION['_notice_type'])) {
            if (!$print) {
                self::admin_notice($_SESSION['_notice_type'], $_SESSION['_notice_message']);
            } else {
                self::print($_SESSION['_notice_type'], $_SESSION['_notice_message']);
            }
            unset($_SESSION['_notice_type']);
            unset($_SESSION['_notice_message']);
        }
    }

    public static function admin_notice($type, $message) {
        add_action('admin_notices', function() use ($type, $message) {
            self::print($type, $message);
        });
    }

    public static function print($type, $message) {
        echo '<div class="notice notice-' . esc_attr($type) . ' social-login"><p>' . wp_kses($message, wp_kses_allowed_html('post')) . '</p></div>';
    }

}