<?php

class SLAIMIG  {

    private static $instance = null;

    public static function instance() {
        return self::$instance ?? self::$instance = new SLAIMIG();
    }

    private function __construct()
    {
        if (isset($_GET['slaimig']) || !strlen(get_option('peepso_slai_migrated'))) {

            new PeepSoError('SLAIMIG');
            $keys = [
                'enable_peepso_integration' => 'slai_enabled',
                'import_avatar' => 'slai_avatars',
            ];

            $field_keys = [
                'first_name' => 'slai_field_first',
                'last_name' => 'slai_field_last',
                'birthdate' => 'slai_field_bday',
            ];

            $migrate = [];

            $option = get_option(PeepSoSocialLoginPlugin::OPTION);

            foreach($keys as $key=>$peepso_key) {
                $migrate[$peepso_key] = 0;
                if (isset($option[$key])) {
                    $migrate[$peepso_key] = $option[$key];
                }
            }


            foreach ($field_keys as $key=>$peepso_key) {
                $migrate[$peepso_key] = 0;
                if (isset($option['peepso_field_mapping'][$key])) {
                    $migrate[$peepso_key] = $option['peepso_field_mapping'][$key];
                }
            }

            new PeepSoError(print_r($migrate, true));

            if (count($migrate)) {
                foreach ($migrate as $peepso_key => $value) {
                    PeepSoConfigSettings::get_instance()->set_option($peepso_key, $value);
                }
            }

            update_option('peepso_slai_migrated', 1);
        }
    }
}

add_action('plugins_loaded', function() {
    SLAIMIG::instance();
});