<?php

class Social_Login_User_Profile_Model
{

    private $table;
    
    public function __construct() {
        global $wpdb;
        $this->table = $wpdb->prefix . 'peepso_social_login_user_profile';
    }

    public function fetch_all($limit = NULL, $offset = 0, $order = NULL, $dir = 'ASC') {
		global $wpdb;

		$query = "SELECT * FROM $this->table ";

		if (isset($order)) {
			$query .= " ORDER BY $order $dir";
        }

		if (isset($limit)) {
			$query .= " LIMIT $offset,$limit";
        }

		return ($wpdb->get_results($query, ARRAY_A));
    }
    
    public function count_all() {
        global $wpdb;

        $query = "SELECT COUNT(*) AS total FROM $this->table ";
        return $wpdb->get_row($query)->total;
    }

    public function create($args) {
        global $wpdb;

        $data = $this->_format_post_data($args);

        if($wpdb->insert($this->table, $data)) {
            return $wpdb->insert_id;
        }

        return 0;
    }

    public function update($id, $args) {
        global $wpdb;

        $data = $this->_format_post_data($args);
        return $wpdb->update($this->table, $data, ['id' => $id]);
    }

    public function delete($id) {
        global $wpdb;

        if (is_array($id)) {
            $where = ' user_id IN (' . implode(',', $id). ')';
        } else {
            $where = ' user_id = ' . $id;
        }

        $result = $wpdb->query("DELETE FROM $this->table WHERE $where");
    }

    public function get($args) {
        global $wpdb;

        $where = [];

        // search by id
        if (isset($args['id'])) {
            $where[] = $wpdb->prepare("id = %d", $args['id']);
        }

        // search by user_id
        if (isset($args['user_id'])) {
            $where[] = $wpdb->prepare("user_id = %d", $args['user_id']);
        }

        // search by provider
        if (isset($args['provider']) && !empty($args['provider'])) {
            $where[] = $wpdb->prepare("provider = %s", $args['provider']);
        }

        // search by email
        if (isset($args['email']) && !empty($args['email'])) {
            $where[] = $wpdb->prepare("email = %s", $args['email']);
        }

        // search by identifier
        if (isset($args['identifier']) && !empty($args['identifier'])) {
            $where[] = $wpdb->prepare("identifier = %s", $args['identifier']);
        }

        if (!empty($where)) {
            $where = ' WHERE ' . implode(' AND ', $where);
        } else {
            $where = '';
        }

        $query = "SELECT * FROM $this->table $where";

        if (isset($args['single'])) {
            return $wpdb->get_row($query);
        } else {
            return $wpdb->get_results($query);
        }

    }

    private function _format_post_data($args) {
        $data = [];

        foreach ($args as $key => $value) {
            $data[$key] = esc_attr($value);
        }
        return $data;
    }
}