<?php


class Social_Login_Invitation_Widget extends WP_Widget
{

    /**
     * Set up the widget name etc
     */
    public function __construct($id = NULL, $name = NULL, $args= NULL) {

        $id     = (NULL !== $id)  ? $id   : 'SocialLoginInvitation';
        $name   = (NULL !== $name)? $name : __('Social Invitation', 'social-login');
        $args   = (NULL !== $args)? $args : ['description' => __('Invite social media friends', 'social-login')];

        parent::__construct(
           $id,
           $name,
           $args
        );
    }

    /**
     * Outputs the content of the widget
     * @param array $args
     * @param array $instance
     * @return void
     */
    public function widget($args, $instance) {
        $providers = PeepSoSocialLoginPlugin::get_instance()->get_provider_option();
        $title = !empty($instance['title']) ? $instance['title'] : __('Connect with:', 'social-login');

        echo PeepSoSocialLoginPlugin::get_instance()->render_output($instance, $args);
    }

    /**
     * Outputs the admin options form
     * @param array $instance The widget options
     */
    public function form($instance) {
        $title = !empty($instance['title']) ? $instance['title'] : '';
        $link = !empty($instance['link']) ? $instance['link'] : '';
        ?>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('title')); ?>"><?php _e('Title:', 'social-login'); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr($title); ?>">
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('link')); ?>"><?php _e('Link:', 'social-login'); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('link')); ?>" name="<?php echo esc_attr($this->get_field_name('link')); ?>" type="url" value="<?php echo esc_attr($link); ?>">
        </p>
        <?php
    }

    public function update($new_instance, $old_instance) {
        $instance = [];
        $instance['title'] = (!empty($new_instance['title'])) ? strip_tags($new_instance['title']) : '';
        $instance['link'] = (!empty($new_instance['link'])) ? strip_tags($new_instance['link']) : '';

        return $instance;
    }
}

// EOF