<?php


class Social_Login_Widget extends WP_Widget
{

    /**
     * Set up the widget name etc
     */
    public function __construct($id = NULL, $name = NULL, $args= NULL) {

        $id     = (NULL !== $id)  ? $id   : 'SocialLogin';
        $name   = (NULL !== $name)? $name : __('Social Login', 'social-login');
        $args   = (NULL !== $args)? $args : ['description' => __('Login using social media account', 'social-login')];

        parent::__construct(
           $id,
           $name,
           $args
        );
    }

    /**
     * Outputs the content of the widget
     * @param array $args
     * @param array $instance
     * @return void
     */
    public function widget($args, $instance) {
        if (is_user_logged_in()) {
            return;
        }

        $title = !empty($instance['title']) ? $instance['title'] : '';
        PeepSoSocialLoginPlugin::get_instance()->login_form([
            'widget_args' => $args,
            'title' => $title
        ]);
    }

    /**
     * Outputs the admin options form
     * @param array $instance The widget options
     */
    public function form($instance) {
        $title = !empty($instance['title']) ? $instance['title'] : site_url() ;
        ?>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('title')); ?>"><?php _e('Title:', 'social-login'); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr($title); ?>">
        </p>
        <?php
    }

    public function update($new_instance, $old_instance) {
        $instance = [];
        $instance['title'] = (!empty($new_instance['title'])) ? strip_tags($new_instance['title']) : '';

        return $instance;
    }
}

// EOF