<?php
// If the details are not open, adjust CSS
$open_pref = get_user_meta(get_current_user_id(), 'social_login_open_' . $provider_key, true);

// get_user_meta might return an empty string
$open = (strlen($open_pref) && 1 == $open_pref) ? false : 'display:none';
// $open = 1;

$enabled = (int) $provider_value['enabled'];
$icon_color = !empty($provider_value['icon-color']) ? 'color:' . $provider_value['icon-color'] . ';' : '';
$background_color = !empty($provider_value['background-color']) ? 'background-color:' . $provider_value['background-color'] . ';' : '';

// if not published, dim the container
$postbox_muted = (0 == $enabled) ? 'postbox-muted' : false;
?>

<div class="postbox tp-postbox--settings no-padd <?php echo esc_attr($postbox_muted); ?>" data-id="<?php echo esc_attr($provider_key); ?>">

	<h3 class="hndle tp-postbox__title ui-sortable-handle tp-handle">

		<div class="postbox-sorting">
			<span class="tfas tfa-arrows"></span>
			<span class="tfas tfa-<?php echo ($open) ? 'expand' : 'compress' ?> tp-providers-toggle"></span>
		</div>

		<div class="tp-postbox__title-label tp-providers-title">

			<div id="providers-<?php echo esc_attr($provider_key); ?>-box-title" class="tp-postbox__title-text tp-providers-title-text">
                <span class="tsc-icon tsc-icon--<?php echo strtolower($provider_key);?>" style="opacity:0">
                    <i class="tfab tfa-<?php echo strtolower($provider_key);?>"></i>
                </span>
                <span class="title"><?php echo (strpos($provider_key, 'Twitter') !== FALSE) ? 'X' : esc_attr($provider_key); ?><?php echo (strpos($provider_key, 'WeChat') !== FALSE ? ' (Beta)' : ''); ?></span>
			</div>

		</div>

    </h3>

	<div class="tp-providers" data-id="<?php echo esc_attr($provider_key); ?>" style="<?php echo esc_attr($open); ?>">
		<div class="tp-settings">

            <div class="tp-social-login <?php echo $enabled ? 'enabled' : 'disabled';?>">

                <table class="form-table" data-provider="<?php echo esc_attr($provider_key); ?>">

                    <?php foreach ($provider_value as $key => $value) : ?>

                        <?php if ($key == 'enabled') :
                            $hide = $value == 0 ? ' hide' : '';
                            ?>
                            <tr valign="top">
                                <th scope="row"><?php echo ucwords(str_replace('_', ' ', $key)); ?></th>
                                <td>
                                    <input name="<?php echo esc_attr($provider_key . '[enabled]'); ?>" class="enable" type="checkbox" value="1" <?php echo $value == 1 ? 'checked' : '';?> />
                                    <a href="#" class="show-info" style="margin-left:10px;">
                                        <span class="dashicons dashicons-info"></span>
                                        <span data-label-show="<?php echo __('Show instructions', 'social-login'); ?>"
                                            data-label-hide="<?php echo __('Hide instructions', 'social-login'); ?>">
                                            <?php echo __('Show instructions', 'social-login'); ?>
                                        </span>
                                    </a>
                                </td>
                            </tr>

                        <?php elseif (is_array($value)) : ?>

                            <?php foreach ($value as $arr_key => $arr_value) : ?>

                                <tr valign="top" class="<?php echo esc_attr($hide); ?>">
                                    <th scope="row"><?php echo ucwords(str_replace('_', ' ', esc_attr($arr_key))); ?></th>
                                    <td>
                                        <?php if ($arr_key == 'key_content') : ?>
                                            <textarea style="width:600px;" rows="6" name="<?php echo esc_attr($provider_key . '[' . $arr_key . ']'); ?>"><?php echo esc_attr($arr_value); ?></textarea>
                                        <?php else: ?>
                                            <input type="text" size="64" name="<?php echo esc_attr($provider_key . '[' . $arr_key . ']'); ?>" value="<?php echo esc_attr($arr_value); ?>"/>
                                        <?php endif; ?>
                                    </td>
                                </tr>

                            <?php endforeach; ?>

                        <?php elseif (in_array($key, ['icon-color', 'background-color'])): ?>

                            <tr valign="top" class="<?php echo esc_attr($hide); ?>">
                                <th scope="row"><?php echo ucwords(str_replace('-', ' ', $key)); ?></th>
                                <td>
                                    <input type="text" data-alpha-enabled="true" size="64" class="color-picker <?php echo esc_attr($key); ?>" name="<?php echo esc_attr($provider_key) . '[' . $key . ']'; ?>" value="<?php echo esc_attr($value); ?>"/>
                                </td>
                            </tr>

                        <?php endif; ?>

                    <?php endforeach; ?>

                </table>

                <div class="info slide slide-up">
                    <?php
                    echo '<p>' . sprintf(__("<b>Application</b> id and secret (also sometimes referred as <b>Consumer</b> key and secret or <b>Client</b> id and secret) are what we call an application credentials. "
                    . "This application will link your website <b>%s</b> to %s API and these credentials are needed in order for %s users to access your website. "
                    . "These credentials may also differ in format, name and content depending on the social network.", 'social-login'), home_url(), $provider_key, $provider_key) . '</p>';

                    echo '<p>' . sprintf(__("To enable authentication with this provider and to register a new %s API Application, follow the steps :", 'social-login'), $provider_key) . '</p>';
                    echo esc_html(Social_Login_Template::exec_template('provider', $provider_key, [
                        'redirect_url' => esc_url(site_url('wp-login.php?action=social_login_authenticated&provider=' . $provider_key))
                    ]));
                    ?>
                </div>

            </div>

        </div>
    </div>  

</div>