<div id="login">
	<div id="login-panel">
		<div id="avatar">
			<img src="<?php echo esc_url($hybridauth_user_profile->photoURL); ?>">
		</div>
		
		<?php echo !empty($error_message) ? '<div id="errors-account-linking" class="error"><p>' . esc_attr($error_message) . '</p></div>' : '' ?>

		<div id="welcome">
			<?php if($provider == 'Google'): ?>
				<span class="tsc-icon tsc-icon--<?php echo strtolower($provider);?>" style="margin:10px auto">
					<img src="<?php echo  PeepSoSocialLoginPlugin::get_asset('img/Google-SVG.svg'); ?>" alt="Google" /> <?php echo $provider ?>
				</span>
			<?php else: ?>
				<span class="tsc-icon tsc-icon--<?php echo strtolower($provider);?>" style="margin:10px auto">
					<i class="tfab tfa-<?php echo strtolower($provider);?>"></i>
				</span>
			<?php endif; ?>

			<b><?php echo sprintf(__('Hi %s', 'social-login'), htmlentities($hybridauth_user_profile->displayName)); ?></b>
			<p><?php echo sprintf(__("You're now signed in with your %s account but you are still one step away from getting into our website", 'social-login'), $provider); ?>.</p>
			<hr/>
		</div>

		<div id="mapping-options">
			<div class="tp-sl-login-gateway-inner">
				<div class="tp-sl-login-gateway tp-sl-login-gateway--login">
					<h4><?php echo __('Already have an account', 'social-login'); ?>?</h4>
					<p style="font-size: 12px;"><?php echo sprintf(__("Link your existing account on our website to your %s ID.", 'social-login'), $provider); ?></p>
					<div valign="top"  width="50%" style="text-align:center;">
						<input type="button" value="<?php _e("Link my account", 'social-login');?>" class="button-primary" onclick="display_mapping_authenticate();" >
					</div>
				</div>

				<?php 
					$email = $hybridauth_user_profile->email;
					$option = get_option(PeepSoSocialLoginPlugin::OPTION);
					$error_message = '';

					if (PeepSo::get_option_new('slai_enabled') && !empty($email)) {
						$valid_email = apply_filters('peepso_register_valid_email', TRUE, $email);
					
						if (!$valid_email) {
							$error_message = sprintf(__('%s is blocked, please use another email address.', 'social-login'), $email);
						}
					} else if (empty($email)) {
						$error_message = sprintf(__("%s did not provide an email address, please fill it below", 'social-login'), ucfirst($provider));
					}

					if (!empty($error_message)) {
						$action = 'display_email_authenticate();';
					} else {
						$action = "document.getElementById('info-form').submit();";
					}
				?>
				
				<div class="tp-sl-login-gateway tp-sl-login-gateway--register">
					<h4><?php _e("New to our website", 'social-login');?>?</h4>
					<p style="font-size: 12px;"><?php echo sprintf(__("Create a new account and it will be associated with your %s ID.", 'social-login'), $provider); ?></p>
					<div valign="top"  width="50%" style="text-align:center;">
						<input type="button" value="<?php _e("Create a new account", 'social-login');?>" class="button-primary" onclick="<?php echo $action; ?>" >
					</div>
				</div>
			</div>
		</div>
		
		<form method="post" action="<?php echo site_url('wp-login.php', 'login_post'); ?>" id="link-form">
			<table id="mapping-authenticate" border="0">
				<tr>
					<td valign="top"  width="50%" style="text-align:center;">
						<h4><?php _e("Already have an account", 'social-login');?>?</h4>

						<p><?php echo sprintf(__("Please enter your username and password of your existing account on our website. Once verified, it will be linked to your %s ID", 'social-login'), ucfirst($provider)); ?>.</p>
					</td>
				</tr>
				<tr>
					<td valign="bottom"  width="50%" style="text-align:left;">
						<label>
							<?php _e("Username", 'social-login');?>
							<br />
							<input type="text" name="username" class="input" value=""  size="25" placeholder="" />
						</label>

						<label>
							<?php _e("Password", 'social-login');?>
							<br />
							<input type="password" name="password" class="input" value="" size="25" placeholder="" />
						</label>

						<input type="submit" value="<?php _e("Continue", 'social-login');?>" class="button-primary" >

						<a href="javascript:void(0);" onclick="display_mapping_options();" class="back-to-options"><?php _e("Back", 'social-login');?></a>
					</td>
				</tr>
			</table>

			<input type="hidden" id="redirect_to" name="redirect_to" value="<?php echo esc_url($redirect_to) ?>">
			<input type="hidden" id="provider" name="provider" value="<?php echo esc_attr($provider) ?>">
			<input type="hidden" id="action" name="action" value="social_login_account_linking">
			<input type="hidden" id="mode" name="mode" value="link">
		</form>

		<?php if (!empty($error_message)): ?>
		
		<form method="post" action="<?php echo site_url('wp-login.php', 'login_post'); ?>" id="email-form">
			<table id="email-authenticate" border="0">
				<tr>
					<td valign="top"  width="50%" style="text-align:center;">
						<h4><?php _e("Enter your email address", 'social-login');?></h4>
						<?php echo isset($error_message) ? '<p>' . $error_message  . '</p>' : ''; ?>
					</td>
				</tr>
				<tr>
					<td valign="bottom"  width="50%" style="text-align:left;">

						<label>
							<?php _e("Email", 'social-login');?>
							<br />
							<input type="email" name="email" class="input" />
						</label>

						<input type="submit" value="<?php _e("Continue", 'social-login');?>" class="button-primary" >

						<a href="javascript:void(0);" onclick="display_mapping_options();" class="back-to-options"><?php _e("Back", 'social-login');?></a>
					</td>
				</tr>
			</table>

			<input type="hidden" id="redirect_to" name="redirect_to" value="<?php echo esc_url($redirect_to) ?>">
			<input type="hidden" id="provider" name="provider" value="<?php echo esc_attr($provider) ?>">
			<input type="hidden" id="action" name="action" value="social_login_account_create">
		</form>

		<?php else: ?>

		<form method="post" action="<?php echo site_url('wp-login.php', 'login_post'); ?>" id="info-form">
			<input type="hidden" id="redirect_to" name="redirect_to" value="<?php echo esc_url($redirect_to) ?>">
			<input type="hidden" id="provider" name="provider" value="<?php echo esc_attr($provider) ?>">
			<input type="hidden" id="action" name="action" value="social_login_account_create">
		</form>

		<?php endif; ?>
	</div>

	<p class="back-to-home">
		<a href="<?php echo home_url(); ?>">&#8592; <?php echo sprintf(__("Back to %s", 'social-login'), get_bloginfo('name')); ?></a>
	</p>
</div>