<body id="loading-screen" onload="init();" mode="<?php echo esc_attr($mode); ?>">
	<table width="100%" border="0" <?php echo $mode == 'error' ? 'class="error"' : ''; ?>>
		<?php if ($mode == 'redirect' || $mode == 'process') : ?>
			<tr>
				<td align="center"><img src="<?php echo PeepSoSocialLoginPlugin::get_asset('img/loading.gif'); ?>" /></td>
			</tr>
		<?php endif; ?>
		
		<tr>
			<td align="center">
				<div>
					<?php 
					if ($mode == 'redirect') {
						echo sprintf(__('Contacting <b>%s</b>, please wait...', 'social-login'),  ucfirst($provider));
					} else if ($mode == 'process') {
						echo __('Processing, please wait...', 'social-login');
						?>
						<form name="loginform" method="post" action="<?php echo esc_url($authenticated_url); ?>">
							<input type="hidden" id="redirect_to" name="redirect_to" value="<?php echo esc_url($redirect_to); ?>">
							<input type="hidden" id="provider" name="provider" value="<?php echo esc_attr($provider) ?>">
							<input type="hidden" id="action" name="action" value="social_login_authenticated">
						</form>
						<?php
					} else if ($mode == 'error') {
						echo esc_html($error_message);
						echo '<p>' . __('Please contact your system administrator to solve this issue.', 'social-login') . '</p>';
					}
					?>
				</div>
			</td>
		</tr>
	</table>
</body>