<div class="tp-sl-steps">
    <div class="slai-admin-sub-content">
        <h2 class="title">Create Apple App</h2>

        <ol>
            <li>Make sure you have an <strong>active subscription for the <a href="https://developer.apple.com/programs/" target="_blank">Apple Developer Program</a></strong>, as that is necessary for both creating and maintaining an Apple App!</li>
            <li>Make sure your site have <b>SSL</b>, since <b>Apple only allows HTTPS urls</b>!</li>
            <li>Navigate to <a href="https://developer.apple.com/account/resources/identifiers/list" target="_blank">https://developer.apple.com/account/resources/identifiers/list</a></li>
            <li>Log in with your Apple Developer credentials if you are not logged in.</li>
        </ol>

        <h3>1.) Create the associated App:</h3>
        <ol>
            <li>Click the <b>blue + icon</b> next to Identifiers, then select the <b>App IDs</b> option and click the "Continue" button.</li>
            <li>Choose the "<strong>App</strong>" option as type and press the "<b>Continue</b>" button.</li>
            <li>Enter a "<b>Description</b>"</li>
            <li>At the "<b>Bundle ID</b>" field select the "<b>Explicit</b>" option and enter your domain name in reverse-domain name style, with the name of the app at its end: <b>com.samplewebsite.slaiapp</b></li>
            <li>Under the "<b>Capabilities</b>" section, tick the "<b>Sign In with Apple</b>" option.</li>
            <li>Scroll up and press the "<b>Continue</b>" button and then the "<b>Register</b>" button.</li>
        </ol>

        <h3>2.) Create the Key:</h3>
        <ol>
            <li>On the left hand side, click on the "<b><a href="https://developer.apple.com/account/resources/authkeys/list" target="_blank">Keys</a></b>" tab.</li>
            <li>Click the <b>blue + icon</b> next to Keys heading.</li>
            <li>Enter a name in the <b>Key Name</b> field.</li>
            <li>Tick the "<b>Sign In with Apple</b>" option, then click on "<b>Configure</b>".</li>
            <li>If you have multiple Apps, then at the "<b>Choose a Primary App ID</b>" field <b>select the App what you just created</b>, then click "<b>Save</b>".</li>
            <li>Finally press the "<b>Continue</b>" button and then the "<b>Register</b>" button.</li>
            <li><b>Don't download the key yet!</b></li>
        </ol>

        <h3>3.) Create the Service:</h3>
        <ol>
            <li>Go to the "<b><a href="https://developer.apple.com/account/resources/identifiers/list/serviceId" target="_blank">Services IDs</a></b>" section, what you will find within the "Identifiers" tab.</li>
            <li>Click the <b>blue + icon</b> next to Identifiers, then select the "<b>Services IDs</b>" option and click the "<b>Continue</b>" button.</li>
            <li>Enter a "<b>Description</b>".</li>
            <li>At the "<b>Identifier</b>" field enter your domain name in reverse-domain name style, with the name of the client at its end: <b>com.samplewebsite.slaiclient</b>
                <ul><li><b>Note:</b> This will also be used as Service Identifier later!</li></ul>
            </li>
            <li>Press the "<b>Continue</b>" button and then the "<b>Register</b>" button.</li>
            <li>In the "<b><a href="https://developer.apple.com/account/resources/identifiers/list/serviceId" target="_blank">Services IDs</a></b>" section, click the service you just created.</li>

            <li>Tick the "<b>Sign In with Apple</b>" option and click the "<b>Configure</b>" button next to it.                <ol>
                    <li>If you have multiple Apps, then at the "Primary App ID" field select the App what you just created.</li>
                    <li>Fill the "<b>Domains and Subdomains</b>" field with your domain name probably: <b>samplewebsite.com</b></li>
                    <li>Add the following URL to the "<b>Return URLs</b>" field:
                    <ul><li><input class="tp-sl-steps__input-link" onClick="this.select();" size="128" readonly="readonly" value="<?php echo esc_url($redirect_url); ?>" /></li></ul>
                </li>
                </ol>
            </li>
            <li>Click the "<b>Next</b>" button then press the "<b>Done</b>" button.</li>
            <li>Finally press the "<b>Continue</b>" button and then the "<b>Save</b>" button.</li>
        </ol>

        <h3>4.) Configure your credentials:</h3>
        <ol>
            <li>
                <strong><u>ID:</u></strong>
                <ol>
                    <li>Navigate to: <b><a href="https://developer.apple.com/account/resources/identifiers/list/serviceId" target="_blank">https://developer.apple.com/account/resources/identifiers/list/serviceId</a></b></li>
                    <li>You will find it under the "<b>IDENTIFIER</b>" column. If you configured the service according to the suggestions, it will probably end to .slaiclient e.g.: <b>com.samplewebsite.slaiclient</b></li>
                </ol>
            </li>
            <li>
                <strong><u>Team ID:</u></strong>                
                <ol>
                    <li>A 10 character long identifier, what you can find on the <b>top-right corner, just under your name</b>.</li>
                </ol>
            </li>
            <li>
                <strong><u>Key ID:</u></strong>
                <ol>
                    <li>Navigate to: <b><a href="https://developer.apple.com/account/resources/authkeys/list" target="_blank">https://developer.apple.com/account/resources/authkeys/list</a></b></li>
                    <li>Click on the <b>name of your Key</b>.</li>
                    <li>You will find your "<b>Private Key ID</b>" under "<b>Key ID</b>".</li>
                </ol>
            </li>
            <li><strong><u>Key Content:</u></strong>                
                <ol>
                    <li>Click the "<b>Download</b>" button to download the key file. <u>Once this file is downloaded, it will no longer be available, so <b>make sure you keep this file safe</b>!</u> </li>
                    <li><b>Open the downloaded file</b> with a text editor, like Notepad, <b><u>copy all of its contents</u></b> and <b>paste it</b> into the "<b>Key Content</b>" field.</li>
                </ol>
            </li>
        </ol>
    </div>
</div>