<?php
class PeepSo3_REST_V1_Endpoint_WPEM_RSVP extends PeepSo3_REST_V1_Endpoint {

    private $event_id;
    private $user_id;

    public $model;

    public function __construct() {

        parent::__construct();

        $this->event_id = $this->input->int('event_id', 0);
        $this->user_id = get_current_user_id();

        // Get event_id from permalink if possible.
        if (!$this->event_id && isset($_GET['event_url'])) {
            $this->event_id = url_to_postid($_GET['event_url']);
        }

        $this->model = new PeepSOWPEM_RSVP_User($this->event_id, $this->user_id);

        $this->state = [
            'status'                => NULL,                // enum('no','yes','maybe') | RSVP status of the User for the Event.
            'user_id'               => $this->user_id,      // int | The ID of the user RSVPing to the Event
            'event_id'              => $this->event_id,     // int | The ID of the Event being RSVPd to
            'modified_date'         => NULL,                // datetime | Last modified date, in site timezone
            'modified_date_gmt'     => NULL,                // datetime | Last modified date, in GMT
            'inviter_id'            => NULL,                // int;optional | The ID of the person who invited the User (if any)
            'error'                 => FALSE                // FALSE if no error, TRUE or string if error
        ];
    }

    /**
     * @param false $no_cache - whether to rely on internal state or force a database read
     * @return array - key/value pairs for current RSVP state
     *
     * This method is used externally as a REST endpoint and internally as "renderer" for other methods
     */
    public function read($no_cache = FALSE) {

        if(NULL === $this->state['status'] || $no_cache) {

            $this->model = new PeepSOWPEM_RSVP_User($this->event_id, $this->user_id);

            if($this->validate()) {
                foreach ($this->state as $key => $value) {
                    $this->state[$key] = $this->model->$key;
                }

                // Treat empty result as "no"
                if (!$this->model->exists) {
                    $this->state['status'] = "no";
                }
            }
        }

        return $this->state;
    }

    public function edit() {
        $status = $this->input->value('status', 'no', ['no', 'yes', 'maybe']);
        return $this->set_status($status);
    }

    private function set_status($status) {
        if($this->validate()) {
            $this->model->rsvp($status);
        }
        return $this->read(TRUE);
    }

    private function validate() {
        if(!$this->state['error'] && !$this->user_id) {
            $this->state['error'] = 'invalid_user_id';
        }

        if(!$this->state['error'] && NULL === $this->model->exists) {
            $this->state['error'] = 'invalid_event_id';
        }

        return  $this->state['error'] ? FALSE : TRUE;
    }

    public function can($method) {
        // @TODO this probably should be more sophisticated
        return TRUE;
    }
}
