<?php
class PeepSo3_REST_V1_Endpoint_WPEM_RSVP_Notifications extends PeepSo3_REST_V1_Endpoint {

    private $event_id;
    private $user_id;
    private $model;

    public function __construct() {

        parent::__construct();

        $this->event_id = $this->input->int('event_id', 0);
        $this->user_id = get_current_user_id();

        $this->model = new PeepSOWPEM_RSVP_User($this->event_id, $this->user_id);

        $this->state = [
            'status'                => TRUE,                // boolean
            'user_id'               => $this->user_id,      // int | The ID of the User
            'event_id'              => $this->event_id,     // int | The ID of the Event
            'error'                 => FALSE                // FALSE if no error, TRUE or string if error
        ];
    }

    /**
     * @param false $no_cache - whether to rely on internal state or force a database read
     * @return array - key/value pairs for current RSVP state
     *
     * This method is used externally as a REST endpoint and internally as "renderer" for other methods
     */
    public function read($no_cache = FALSE) {

        if(NULL === $this->state['status'] || $no_cache) {
            $this->state['status'] = (1 == get_post_meta($this->event_id,'peepso_wpem_rsvp_notifications', TRUE)) ? TRUE : FALSE;
            $this->state['event_id'] = $this->event_id;
            $this->state['user_id'] = $this->user_id;
        }

        return $this->state;
    }

    public function edit() {
        $status = $this->input->value('status', '1', [1, 0]);
        update_post_meta($this->event_id, 'peepso_wpem_rsvp_notifications', $status);

        // Trigger notifications delete or rebuild
        do_action('peepso_wpem_user_rsvp',['user_id'=> -1,'event_id'=>$this->event_id,'status'=>'yes']);

        return $this->read(TRUE);
    }


    public function can($method) {

        $event = get_post($this->event_id);

        if(!$event instanceof WP_Post || $event->post_author != $this->user_id) {
            return FALSE;
        }

        return TRUE;
    }
}
