<?php

class PeepSoConfigSectionWPEM extends PeepSoConfigSectionAbstract
{
    // Builds the groups array
    public function register_config_groups()
    {
        $this->context = 'left';
        $this->profiles();
        $this->rsvp();
        $this->overrides();

        $this->context = 'right';
        $this->activity_stream();
    }

    private function profiles() {

        /** Profiles - Enable */
        $descript = '';
        $has_organizers = get_option('enable_event_organizer');
        $has_venues = get_option('enable_event_venue');

        if($has_organizers ||  $has_venues) {
            if ($has_organizers && $has_venues) {
                $descript = "Organizers and Venues";
            } elseif ($has_organizers) {
                $descript = "Organizers";
            } elseif ($has_venues) {
                $descript = "Organizers";
            }

            $descript .= " management is currently in BETA";
        }

        if(strlen($descript)) {
            $this->args('descript',
                $descript
            );
        }



        $this->set_field(
            'wpem_profiles_enable',
            __('Enabled','peepso-wpem'),
            'yesno_switch'
        );


        /** Profiles - Profile Owner Only */
        $this->args('descript',__('Enabled: the link in profile navigation shows only to profile owners ("only me" mode).','peepso-wpem'));
        $this->set_field(
            'wpem_profiles_owner_only',
            __('Profile owner only','peepso-wpem'),
            'yesno_switch'
        );

        /** Separator - navigation **/
        $this->set_field(
            'separator_display_options',
            __('Display options', 'peepso-wpem'),
            'separator'
        );


        /** Profiles - orderby */
        $options = [
            'event_start_date' =>  __('Date: start', 'peepso-wpem'),
            'modified' =>  __('Date: last modified', 'peepso-wpem'),
            'ID' =>  __('Date: created', 'peepso-wpem'),
            'title' =>  __('Title', 'peepso-wpem'),
        ];
        $this->args('options', $options);
        $this->set_field(
            'wpem_profiles_orderby',
            __('Order by', 'peepso-wpem'),
            'select'
        );

        $options = [
            'ASC' =>  '↑',
            'DESC' =>  '↓',
        ];
        $this->args('options', $options);
        $this->set_field(
            'wpem_profiles_order',
            __('Order', 'peepso-wpem'),
            'select'
        );

        $this->set_field(
            'wpem_profiles_show_filters',
            __('Show filters', 'peepso-wpem'),
            'yesno_switch'
        );

        $this->set_field(
            'wpem_profiles_show_categories',
            __('Show categories', 'peepso-wpem'),
            'yesno_switch'
        );

        $this->set_field(
            'wpem_profiles_show_event_types',
            __('Show event types', 'peepso-wpem'),
            'yesno_switch'
        );



        /** Separator - navigation **/
        $this->set_field(
            'separator_navigation',
            __('Navigation', 'peepso-wpem'),
            'separator'
        );


        /** Profiles - slug */
        $this->args('descript',PeepSo::get_page('profile').PeepSoUser::get_instance()->get_username().'/<span style="font-weight:bold" id="ps-wpem-slug-preview">'.PeepSo::get_option_new('wpem_profiles_slug').'</span>');
        $this->set_field(
            'wpem_profiles_slug',
            __('URL Slug', 'peepso-wpem'),
            'text'
        );

        /** Profiles - label */
        $this->set_field(
            'wpem_profiles_label',
            __('Label', 'peepso-wpem'),
            'text'
        );


        /** Separator - FEM */
        $this->set_field(
            'separator_fem',
            __('Frontend Event Management', 'peepso-wpem'),
            'separator'
        );


        /** FEM enable */
        $this->args('descript',
            sprintf(__('Enabled: additional sub-menus will show in user profiles to create and manage events. Shortcodes %s and %s are used respectively.','peepso-wpem'),'<code>[submit_event_form]</code>','<code>[event_dashboard]</code>')
        );
        $this->set_field(
            'wpem_fem_enable',
            __('Enabled', 'peepso-wpem'),
            'yesno_switch'
        );


        $this->set_group(
            'profile',
            __('Profile integration', 'peepso-wpem'),
            __('Shows the events tab in PeepSo profiles.', 'peepso-wpem')
        );
    }

    private function overrides() {

        /** Separator - General **/
        $this->set_field(
            'wpem_separator_general',
            __('General','peepso-wpem'),
            'separator'
        );


        /** Two column box view **/
        $this->set_field(
            'wpem_two_column_box_view',
            __('Two columns in box view','peepso-wpem'),
            'yesno_switch'
        );

        /** Minimiize filters **/
        // $this->args('descript',__('Hides the filters under an icon in event listings. Works in PeepSo profiles and main event listing (if PeepSo Wrapper is enabled)','peepso-wpem'));
        // $this->set_field(
        //     'wpem_filters_minimized',
        //     __('Minimized filters','peepso-wpem'),
        //     'yesno_switch'
        // );

        /** WPEM Page Wrapper */
        $this->args('descript',sprintf(__('Wraps %s in PeepSo HTML and displays the PeepSo toolbar on top.','peepso-wpem'),'<a target="_blank" href="'.admin_url('edit.php?post_type=event_listing&page=event-manager-settings#settings-event_pages').'">'.__('WPEM pages','peepso-wpem').'</a>'));
        $this->set_field(
            'wpem_peepso_wrapper_enable',
            __('PeepSo Wrapper','peepso-wpem'),
            'yesno_switch'
        );

        /** Separator - Single Event View **/
        $this->set_field(
            'wpem_separator_single',
            __('Single event view','peepso-wpem'),
            'separator'
        );

//        $this->args('descript','Works only if WPEM "organizers" feature is enabled. PeepSo will replace the organizer name on the top of the event details page with author name and profile link.');
//        $this->args('options', [0=>'Never',1=>'When empty',2=>'Always'] );
//        $this->set_field(
//            'wpem_organizer_override',
//            __('Top: show PeepSo Author instead WPEM Organizers','peepso-wpem'),
//            'select'
//        );

        $this->args('descript','A small box with the PeepSo user name and profile link will be shown in the siedbar of the single event view.');
        $this->set_field(
            'wpem_organizer_side',
            __('Side: show PeepSo author info','peepso-wpem'),
            'yesno_switch'
        );


        $this->set_group(
            'overrides',
            __('Overrides', 'peepso-wpem')
        );
    }

    private function rsvp() {

        /** RSVP MASTER **/
        $this->set_field(
            'wpem_rsvp_enable',
            __('Enabled','peepso-wpem'),
            'yesno_switch'
        );


        /** ATTENDEES IN SIDEBAR **/
        $options = [];
        for($i=0;$i<=100;$i++) {
            $options[$i]=$i;
            if($i==0) {
                $options[$i] = __('No', 'peepso-wpem');
            }
        }

        $this->args('options',$options);
        $this->set_field(
            'wpem_rsvp_sidebar_attendees',
            __('Attendees in sidebar','peepso-wpem'),
            'select'
        );

        /** DISABLE WPEM NATIVE REGISTRATIONS **/
        $this->args('descript', __('PeepSo RSVP system is designed to replace WPEM registrations. Please do not enable WPEM registrations together with PeepSo RSVP unless you explicitly need both.','peepso-wpem'));
        $this->set_field(
            'wpem_display_event_registration_method',
            __('WPEM registrations','peepso-wpem'),
            'yesno_switch'
        );



        $this->set_group(
            'rsvp',
            'RSVP',
            'Registered users can join events'
        );
    }

    private function activity_stream()
    {
        // Privacy options
        $privacy = [];

        foreach(PeepSoPrivacy::get_instance()->get_access_settings() as $key => $value) {
            //if(in_array($key, array(30,40))) { continue; }
            $privacy[$key] = $value['label'];
        }

        // Activity stream integration sections
        $sections = [ 'new_event'=> __('New events','peepso-wpem'),'rsvp_yes'=>__('RSVP "yes"','peepso-wpem').' (BETA)'];

        // Loop through all and build settings accordingly
        foreach($sections as $section=>$separator) {


            $this->set_field(
                'wpem_activity_'.$section.'_separator',
                $separator,
                'separator'
            );

            if('new_event' == $section && class_exists('WP_Event_Manager_Recurring')) {
                $this->args('descript', __('For recurring events, the stream entry will only be created for the parent post','peepso-wpem'));
            }
            $this->set_field(
                'wpem_activity_'.$section.'_enable',
                __('Enabled', 'peepso-wpem'),
                'yesno_switch',
            );


            // Action text
            $this->set_field(
                'wpem_activity_'.$section.'_action_text',
                'Action text',
                'text'
            );

            $this->args('descript', __('The title of  the event will be displayed after the action text as a link','peepso-wpem'));
            $this->set_field(
                'wpem_activity_'.$section.'_title_after_action_text',
                __('Append title', 'peepso-wpem'),
                'yesno_switch'
            );

            $this->args('options', $privacy);

            $this->set_field(
                'wpem_activity_'.$section.'_privacy',
                __('Default privacy', 'peepso-wpem'),
                'select'
            );
        }


        $this->set_field(
            'wpem_activity_advanced_separator',
            'Advanced',
            'separator'
        );

        $this->args('descript','If enabled, PeepSo will delete stream posts when an event is unpublished / deleted or when user changes their RSVP status to something other than "yes". <br><br><b>This is a highly experimental feature which can lead to irretrievable post/content loss</b>.');
        $this->set_field(
            'wpem_activity_cleanup_enable',
            __('Allow automatic stream deletions', 'peepso-wpem').' (BETA)',
            'yesno_switch'
        );




        $this->set_group(
            'activity_stream',
            __('Activity Stream', 'peepso-wpem'),
            __('Automatically create PeepSo stream posts related to events', 'peepso-wpem')
        );
    }

}
