<?php

class PeepSoWPEM_Activity
{
    private static $instance;

    const META = 'peepso_wpem_activity';
    const META_NEW_EVENT = 'peepso_wpem_activity_new_event';
    const META_RSVP_YES = 'peepso_wpem_activity_rsvp_yes';

    public $module_id_new_event;
    public $module_id_rsvp_yes;

    public static function get_instance()
    {
        if (self::$instance === NULL) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    public function __construct()
    {
        /** ALL TYPES **/

        // Render: Stream action
        add_filter('peepso_activity_stream_action', array(&$this, 'activity_stream_action'), 99, 2);

        // Render: Embed
        add_filter('peepso_activity_content', array(&$this, 'activity_content'),1,2);

        // Cleanup: stream post deleted manually
        add_filter('peepso_delete_content', function($id) {
            global $wpdb;

            // New Event
            $wpdb->delete($wpdb->prefix.'postmeta', array('meta_value'=>$id, 'meta_key'=>self::META_NEW_EVENT));
            $wpdb->delete($wpdb->prefix.PeepSoActivity::TABLE_NAME, array('act_external_id'=>$id, 'act_module_id'=>$this->module_id_new_event));

            // RSVP YES
            $wpdb->query("DELETE FROM {$wpdb->usermeta} WHERE `meta_value`='$id' AND `meta_key` LIKE '".self::META_RSVP_YES."%'");
            $wpdb->delete($wpdb->prefix.PeepSoActivity::TABLE_NAME, array('act_external_id'=>$id, 'act_module_id'=>$this->module_id_rsvp_yes));
        });

        // Render: disable post actions
        add_filter('peepso_post_filters', function($options){
            $post = $options['post'];

            if (in_array(intval($post->act_module_id), [$this->module_id_rsvp_yes, $this->module_id_new_event])) {

                // disable "edit"
                if (isset($options['acts']['edit'])) {
                    unset($options['acts']['edit']);
                }

                // disable "move"
                if (isset($options['acts']['move'])) {
                    unset($options['acts']['move']);
                }

            }

            return $options;
        }, 50,1);

        // Render: add post actions
        add_filter('peepso_activity_post_actions', function($options) {
            $post = $options['post'];

            if (in_array(intval($post->act_module_id), [$this->module_id_rsvp_yes, $this->module_id_new_event])) {
                if (!get_current_user_id() || PeepSoWPEM_Permissions::user_can_rsvp()) {
                    $states = PeepSoWPEM_RSVP::states();
                    $options['acts']['rsvp'] = [
                        'href' => '#',
                        'label' => $states['no']['label'],
                        'class' => 'ps-post__action ps-dropdown ps-dropdown--menu ps-wpem--dropdown-rsvp ps-js-rsvp-toggle',
                        'icon' => 'gcis ' . $states['no']['icon'],
                        'data-event-id' => PeepSoWPEM_Activity::get_event_id($post)
                    ];
                }
            }

            return $options;
        });

        // Cleanup after delete / unpublish event
        // ...

        /** New Event **/
        $this->module_id_new_event = 1234;//PeepSo_WPEM_Plugin::PLUGIN_EDD;

        // Publish event
        //add_action( 'publish_event_listing', [&$this,'activity_new_event_publish'],10,2);
        add_action( 'publish_event_listing', function($ID, $post){
            return $this->publish($ID, $post->post_author, 'new_event', self::META_NEW_EVENT, $this->module_id_new_event);
        },10,2);

        add_action( 'save_post', function($post_id, $post, $update) {
            $post = get_post($post_id);

            if ($post->post_type == 'event_listing') {
                $this->publish($post_id, $post->post_author, 'new_event', self::META_NEW_EVENT, $this->module_id_new_event, FALSE, $update);

                // update rsvp posts
                global $wpdb;

                $query = "SELECT meta_value FROM $wpdb->usermeta WHERE meta_key = %s";
                $results = $wpdb->get_results($wpdb->prepare($query, self::META_RSVP_YES . '_' . $post_id));

                if(count($results)) {
                    foreach ($results as $row) {
                        $ID =$row->meta_value;
                        $wpdb->query($wpdb->prepare("UPDATE $wpdb->posts SET post_status = %s WHERE ID = %d", $post->post_status, $ID));
                    }
                }
            }
        }, 10, 3 );

        /** RSVP  **/
        $this->module_id_rsvp_yes = $this->module_id_new_event+1;

        // User RSVPs event
        add_action( 'peepso_wpem_user_rsvp', function($args) {

            $meta = self::META_RSVP_YES.'_'.$args['event_id'];
            $user_id = $args['user_id'];

            // Join
            if($args['status'] == 'yes') {
                return $this->publish($args['event_id'], $user_id, 'rsvp_yes', $meta, $this->module_id_rsvp_yes, TRUE);
            }

            // Leave
            if(PeepSo::get_option_new('wpem_activity_cleanup_enable')) {
                $post_id = get_user_meta($user_id, $meta, TRUE);

                if (strlen($post_id) && is_numeric($post_id) && 0 < $post_id) {
                    global $wpdb;
                    $act = $wpdb->get_row($wpdb->prepare("SELECT * FROM $wpdb->prefix" . PeepSoActivity::TABLE_NAME . " WHERE act_external_id= %s AND act_module_id = %s", $id, $this->module_id_rsvp_yes));

                    // There is a post that needs to be deleted
                    $activity = PeepSoActivity::get_instance();
                    $activity->delete_post($post_id);
                    $activity->delete_activity($act->act_id);
                }
            }
        });

        add_action('before_delete_post', function($post_id) {
            $post = get_post($post_id);
            if ($post->post_type != 'event_listing') { return; }

            $activity_post_id = get_post_meta($post_id, self::META_NEW_EVENT, TRUE);
            if ($activity_post_id) {
                $activity_post = get_post($activity_post_id);
                global $wpdb;

                $act = $wpdb->get_row( $wpdb->prepare( "SELECT * from $wpdb->prefix" . PeepSoActivity::TABLE_NAME . " WHERE act_external_id= %s AND act_module_id = %s AND act_owner_id = %s", $activity_post->ID, $this->module_id_new_event, $activity_post->post_author));
                
                if( !$act ) return ;
    
                $activity = PeepSoActivity::get_instance();
                $activity->delete_activity($act->act_id);
                $activity->delete_post($activity_post->ID);


                if (PeepSo::get_option_new('wpem_activity_cleanup_enable')) {
                    // clean usermeta
                    $wpdb->query($wpdb->prepare("DELETE $wpdb->usermeta WHERE meta_key = %s", self::META_RSVP_YES . '_' . $post_id));

                    // clean posts
                    $post_ids = $wpdb->get_col($wpdb->prepare("SELECT ID FROM $wpdb->posts WHERE post_content LIKE %s", '%:' . $post_id . ',%'));
                    if (count($post_ids)) {
                        foreach ($post_ids as $id) {
                            $act = $wpdb->get_row($wpdb->prepare("SELECT * FROM $wpdb->prefix" . PeepSoActivity::TABLE_NAME . " WHERE act_external_id= %s AND act_module_id = %s", $id, $this->module_id_rsvp_yes));
                            $activity->delete_activity($act->act_id);
                            $activity->delete_post($id);
                        }
                    }
                }
            }

        }, 10, 1);

        // hide activity for expired events
        add_filter('peepso_show_post_no_html', function($no_html, $post_data) {
            if ($post_data['post_status'] == 'expired' && strpos($post_data['post_content'], '"post_type":"event_listing"') !== FALSE) {
                $no_html = TRUE;

                if (PeepSo::get_option_new('wpem_activity_cleanup_enable') && $post_data['act_id']) {
                    $activity = PeepSoActivity::get_instance();
                    $activity->delete_activity($post_data['act_id']);
                }
            }

            return $no_html;
        }, 10, 2);

    }

    private function publish($post_id, $user_id, $section,  $meta, $module, $user_meta = FALSE, $update = FALSE) {
        // is activity posting enabled?
        if (0 == PeepSo::get_option_new('wpem_activity_'.$section.'_enable')) 			{	return( FALSE );	}
        
        // get post
        $post = get_post($post_id);

        // is this a supported post type?
        if('event_listing' != $post->post_type) 			                                    {	return( FALSE );	}

        // don't publsh if it's a child event (created by Recurring add-on)
        if($post->post_parent > 0)                                                              {	return( FALSE );	}
        if (!$update) {
            // is the event published?
            if(!in_array($post->post_status,  array('publish')))         			            {	return( FALSE );	}

            // is this RSVP by the event author?
            if('rsvp_yes' == $section && $post->post_author == $user_id)         			    {	return( FALSE );	}

            // check if it's not marked as already posted to activity and has valid act_id
            if($user_meta) {
                $act_id = get_user_meta($user_id, $meta, TRUE);
            } else {
                $act_id = get_post_meta($post->ID, $meta, TRUE);
            }
            if(strlen($act_id) && is_numeric($act_id) && 0 < $act_id) 				            {	return( NULL );	    }
        }

        // If stream already posted. skip creating new stream.
        $activity_post_id = get_post_meta($post_id, $meta, TRUE);
        if ($activity_post_id) {
            $activity_post = get_post($activity_post_id);
            if ($activity_post) {
                // Update the post into the database
                $peepso_post = array(
                    'ID'           => $activity_post->ID,
                    'post_status'  => $post->post_status,
                    'post_date'		=> $post->post_date,
                    'post_date_gmt' => $post->post_date_gmt,
                );
                wp_update_post( $peepso_post );
                return ;
            }
        }

        // build JSON to be used as post content for later display
        $content = array(
            'post_id' => $post->ID,
            'post_type' => $post->post_type,
            'meta' => $meta,
            'permalink' => get_permalink($post->ID),
        );

        $extra = array(
            'module_id'     => $module,
            'act_access'    => PeepSo::get_option_new('wpem_activity_'.$section.'_privacy'),
            'post_date'		=> current_time('mysql'),
            'post_date_gmt'	=> current_time('mysql', 1),
        );

        $content=json_encode($content);

        // create an activity item
        $act = PeepSoActivity::get_instance();
        $act_id = $act->add_post($user_id, $user_id, $content, $extra);

        update_post_meta($act_id, '_peepso_display_link_preview', 0);
        delete_post_meta($act_id, 'peepso_media');

        if ($post->post_status != 'publish') {
            $peepso_post = array(
                'ID'           => $act_id,
                'post_status'  => $post->post_status,
                'post_date'		=> $post->post_date,
                'post_date_gmt' => $post->post_date_gmt,
            );
            wp_update_post( $peepso_post );
        }

        if($user_meta) {
            add_user_meta($user_id, $meta, $act_id, TRUE);
        } else {
            add_post_meta($post->ID, $meta, $act_id, TRUE);
        }

    }

    /** NEW EVENT */

//    function activity_new_event_publish( $ID, $post ) {
//        // is this a supported post type?
//        if('event_listing' != $post->post_type) 			                                {	return( FALSE );	}
//
//        // is the event published?
//        if(!in_array($post->post_status,  array('publish')))         			            {	return( FALSE );	}
//
//        // is activity posting enabled?
//        if(0 == PeepSo::get_option_new('wpem_activity_new_event_enable')) 			{	return( FALSE );	}
//
//        // check if it's not marked as already posted to activity and has valid act_id
//        $act_id = get_post_meta($ID, self::META_NEW_EVENT, TRUE);
//        if(strlen($act_id) && is_numeric($act_id) && 0 < $act_id) 				            {	return( NULL );	    }
//
//        // author is not always the current user - ie when admin publishes a post written by someone else
//        $user_id = $post->post_author;
//
//        // build JSON to be used as post content for later display
//        $content = array(
//            'post_id' => $ID,
//            'post_type' => $post->post_type,
//            'meta' => self::META_NEW_EVENT,
//            'permalink' => get_permalink($ID),
//        );
//
//        $extra = array(
//            'module_id' => $this->module_id_new_event,
//            'act_access'=> PeepSo::get_option_new('wpem_activity_new_event_privacy'),
//            'post_date'		=> current_time('mysql'),
//            'post_date_gmt'	=> current_time('mysql', 1),
//        );
//
//        $content=json_encode($content);
//
//        // create an activity item
//        $act = PeepSoActivity::get_instance();
//        $act_id = $act->add_post($user_id, $user_id, $content, $extra);
//
//        update_post_meta($act_id, '_peepso_display_link_preview', 0);
//        delete_post_meta($act_id, 'peepso_media');
//
//        // mark this post as already posted to activity
//        add_post_meta($ID, self::META_NEW_EVENT, $act_id, TRUE);
//
//        return TRUE;
//    }

    /** ALL TYPES **/

    public function activity_content( $content, $post = NULL )
    {
        if(!stristr($content, self::META)) {
            return $content;
        }

        $content = strip_tags(get_post_field('post_content', $post, 'raw'));

        if($target_post = json_decode($content)) {
            $content = get_permalink($target_post->post_id);

            /*
             * Issue #5124.
             *
             * Disables lazy loading on iframe which is enabled by default on WordPress 5.7.
             * See: https://core.trac.wordpress.org/ticket/50756
             */
            add_filter('wp_iframe_tag_add_loading_attr', '__return_false');

            $content = apply_filters('the_content', $content);

            remove_filter('wp_iframe_tag_add_loading_attr', '__return_false');
        }


        global $post;
        update_post_meta($post->ID, '_peepso_display_link_preview', 0);
        delete_post_meta($post->ID, 'peepso_media');

        return $content;
    }

    public function activity_stream_action($action, $post)
    {
        $section = FALSE;

        if ($this->module_id_new_event == intval($post->act_module_id)) {
            $section = 'new_event';
        }

        if ($this->module_id_rsvp_yes == intval($post->act_module_id)) {
            $section = 'rsvp_yes';
        }


        if(strlen($section)) {
            $action = PeepSo::get_option_new('wpem_activity_' . $section . '_action_text');

            $content = strip_tags(get_post_field('post_content', $post, 'raw'));
            if ($target_post = json_decode($content)) {

                if (1 == PeepSo::get_option('wpem_activity_' . $section . '_title_after_action_text', 0)) {
                    $wp_post = get_post($target_post->post_id);
                    $action .= sprintf(' <a class="ps-wpem-action-title" href="%s">%s</a>', get_the_permalink($wp_post->ID), $wp_post->post_title);
                }
            }

        }

        return ($action);
    }

    public static function get_event_id($post)
    {
        if ($post instanceof WP_Post) {
            if ('event_listing' === $post->post_type) {
                return $post->ID;
            } else if ('peepso-post' === $post->post_type) {
                $content = strip_tags(get_post_field('post_content', $post, 'raw'));
                if (stristr($content, self::META)) {
                    $event_post = json_decode($content);
                    return $event_post->post_id;
                }
            }
        }

        return FALSE;
    }

}
