<?php
class PeepSoWPEM_Notifications
{
    private static $instance;

    public static function get_instance()
    {
        if (self::$instance === NULL) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    public function __construct()
    {
        add_action('peepso_wpem_user_rsvp', function ($args) {

            if ($args['status'] != 'yes') {
                // If the RSVP is "no" or "maybe", we will only update the existing record
                $delete = FALSE;
                $action = 'update';
            } else {
                // If the RSVP is "yes" we are re-creating the item, so that it is moved to the top of the notification list
                $action = 'replace';
                $delete = TRUE; // we need to delete the old record before making a new one
            }

            $event = get_post($args['event_id']);

            if (!$event instanceof WP_Post || $event->post_type != 'event_listing') {
                return;
            }

            // Do nothing if author himself RSVPs
            if ($args['user_id'] == $event->post_author) {
                return;
            }

            $notify = (1 == get_post_meta($event->ID,'peepso_wpem_rsvp_notifications', TRUE)) ? TRUE : FALSE;

            global $wpdb;

            $where = array(
                'not_type' => 'wpem_rsvp_yes',
                'not_external_id' => $event->ID,
            );

            $query = "SELECT * FROM $wpdb->prefix". PeepSoNotifications::TABLE ." WHERE `not_type` = 'wpem_rsvp_yes' AND `not_external_id` = {$event->ID}";
            $exists = count($wpdb->get_results($query));
            if(!$exists) {
                $action = 'replace';
            }

            $first_attendee = false;
            if($notify) {

                if ($action == 'replace') {
                    $delete = TRUE;
                }

                // Count users who are "going"
                $PeepSOWPEM_RSVP_Users = new PeepSOWPEM_RSVP_Users($event->ID);
                $going = $PeepSOWPEM_RSVP_Users->get('yes', TRUE);
                
                $going_count = count($going);

                // Do nothing if nobody is going
                if ($going_count) {
                    // The first (most recent)  "yes" on the list is treated as the notification author
                    $first_attendee = array_shift($going);

                    $going_count = count($going); // counts only additional people on top of the first_attendee

                    // If exactly 2 people are going, grab the name of the second person
                    if ($going_count == 1) {
                        foreach ($going as $attendee) {
                            $PeepSoUser = PeepSoUser::get_instance($attendee);
                            $second_attendee = $PeepSoUser->get_firstname();
                        }
                    }
                } else {
                    $delete = TRUE; // nobody is going, need to delete the notification
                }
            } else {
                $delete = TRUE;
            }

            if ($delete) {
                $wpdb->delete($wpdb->prefix . PeepSoNotifications::TABLE, $where);
            }

            if($notify) {

                $owner = $event->post_author;

                if($going_count == 0) {
                    $i18n = __('is attending your event', 'peepso-wpem');
                    $message = 'is attending your event';
                    $not_args = ['peepso-wpem'];

                } elseif($going_count == 1) {
                    $i18n = __('and %s %s %s are attending your event', 'peepso-wpem');
                    $message = 'and %s %s %s are attending your event';
                    $not_args =[
                        'peepso-wpem',
                        '<strong>',
                        $second_attendee,
                        '</strong>'
                    ];

                } else {
                    $i18n = __('and %s %s more users %s are attending your event', 'peepso-wpem');
                    $message = 'and %s %s more users %s are attending your event';
                    $not_args = [
                        'peepso-wpem',
                         '<strong>',
                        $going_count,
                        '</strong>',
                    ];
                }

                if ($first_attendee) {
                    if ($action == 'replace') {
                        $PeepSoNotifications = new PeepSoNotifications();
                        $PeepSoNotifications->add_notification_new($first_attendee, $owner, $message, $not_args, 'wpem_rsvp_yes', PeepSo_WPEM_Plugin::MODULE_ID, $args['event_id']);
                    }
    
                    if ($action == 'update') {
                        $wpdb->update($wpdb->prefix . PeepSoNotifications::TABLE, ['not_from_user_id' => $first_attendee, 'not_message' => $message,'not_message_args'=>json_encode($not_args)], $where);
                    }
                }
            }

        }, 10);

        add_action('peepso_profile_notification_link', function($link, $note_data){

            $not_types = array(
                'wpem_rsvp_yes',
            );

            $not_type = $note_data['not_type'];

            if (in_array($not_type, $not_types)) {
                $link = get_permalink($note_data['not_external_id']);
            }

            return $link;
        },10,2);


    }
}