<?php

class PeepSoWPEM_Permissions {

    private static $instance;

    public static function get_instance() {
        return self::$instance ? self::$instance : new self();
    }

    private function __construct() {

        // Hijack the WPEM shortcodes if user is not able to create / manage events
        if(!self::user_can_create()) {
            add_shortcode('submit_event_form', function ($one, $two, $three) {
                return __('Sorry, you can\'t create events','peepso-wpem');
            }, 10, 3);

            add_shortcode('event_dashboard', function ($one, $two, $three) {
                return __('Sorry, you can\'t manage events','peepso-wpem');
            }, 10, 3);
        }
    }

    public static function user_can_create() {
        return apply_filters('peepso_permissions_wpem_create',(get_current_user_id()>0));
    }

    public static function user_can_rsvp() {
        return apply_filters('peepso_permissions_wpem_rsvp',PeepSo::get_option_new('wpem_rsvp_enable'));
    }
}

