<?php

class PeepSoWPEM_RSVP {

    private static $_instance = NULL;

    const TABLE = 'peepso_wpem_rsvp';

    private $db_version = 1;

    public function __construct()
    {
        @include_once( ABSPATH . 'wp-admin/includes/upgrade.php' );

        if(!function_exists('dbDelta')) {
            new PeepSoError("dbDelta() not found");
            return;
        }

        // Run dbDelta() once in a while no matter what
        $override = (rand(1,100) == 1) ? TRUE : FALSE;

        global $wpdb;
        $version = PeepSo::PLUGIN_VERSION.PeepSo::PLUGIN_RELEASE.'-'.$this->db_version;
        $charset_collate = $wpdb->get_charset_collate();

        // DB table: peepso_activity_views
        if(get_option(self::TABLE) != $version || $override) {

            $table = $wpdb->prefix . self::TABLE;

            $sql = "CREATE TABLE $table (
					id BIGINT(20) NOT NULL AUTO_INCREMENT,
					user_id BIGINT(20) NOT NULL,
					event_id BIGINT(20) NOT NULL,
					status ENUM('yes','no','maybe','invited') NOT NULL DEFAULT 'maybe',
					inviter_id BIGINT(20) NOT NULL DEFAULT 0,
					date_modified datetime,
					date_modified_gmt datetime,
				    PRIMARY KEY (id),
				    UNIQUE KEY user_event (user_id, event_id)
				  ) ENGINE=InnoDB $charset_collate;";

            dbDelta($sql);
            update_option(self::TABLE, $version);
        }

        // Render the HTML element used to anchor our RSVP buttons in the front-end
        if(!is_admin()) {
            add_action('single_event_listing_button_start', ['PeepSoWPEM_RSVP', 'hook_template']);
            add_action('event_already_registered_title', ['PeepSoWPEM_RSVP', 'hook_template']);
        }
    }

    public static function hook_template() {
        global $post;
        if (PeepSo_WPEM_Plugin::check_post_type($post)) {
            echo PeepSoTemplate::exec_template('rsvp','dropdown',['post'=>$post], TRUE);
        }
    }

    public static function states() {
        return [
            'yes' => [
                'icon' => 'gcis gci-calendar-check',
                'label' => __('Attending', 'peepso-wpem'),

            ],
            'maybe' => [
                'icon' => 'gcis gci-calendar-plus',
                'label' => __('Interested', 'peepso-wpem'),
            ],
            'no' => [
                'icon' => 'gcis gci-calendar',
                'label' => __('Not attending', 'peepso-wpem'),
            ],
        ];
    }
    public static function get_instance()
    {
        if (NULL === self::$_instance) {
            self::$_instance = new self();
        }
        return (self::$_instance);
    }
}
