<?php

class PeepSOWPEM_RSVP_User {

    public $user_id;
    public $event_id;

    public $exists; // BOOL - does a DB record exist? NULL if invalid user / event id
    public $status; // ['yes', 'no', 'maybe', 'invited'] from "status" column;
    public $modified_date;
    public $modified_date_gmt;
    public $inviter_id;
    public $date_modified;
    public $date_modified_gmt;

    private $db;
    private $table;
    private $where;
    private $where_string;
    
    public static $default_state = 'no';
    public static $states = ['no','yes','maybe','invited'];

    public $error;

    public function __construct(int $event_id, int $user_id) {

        global $wpdb;

        if(!$user_id) {
            $user_id = get_current_user_id();
        }

        $user_id = intval($user_id);
        $event_id = intval($event_id);

        if(!$user_id || !$event_id) {
            $this->exists = NULL;
            return NULL;
        }

        $this->user_id = intval($user_id);
        $this->event_id = intval($event_id);

        $this->db = $wpdb;

        $this->table = $this->db->prefix.PeepSOWPEM_RSVP::TABLE;

        $this->where = ['user_id' => $this->user_id, 'event_id' => $this->event_id];
        $this->where_string = "WHERE user_id = $this->user_id AND event_id = $this->event_id";

        $this->exists = $this->exists();
        $this->status = FALSE;
        $this->inviter_id = FALSE;
        $this->modified_date = FALSE;
        $this->modified_date_gmt = FALSE;
        $this->error = FALSE;

        if($this->exists) {
            $this->init();
        }
    }

    private function init() {

        $row = $this->db->get_row("SELECT * FROM $this->table $this->where_string");

        $this->status = $row->status;

        if(is_numeric($row->inviter_id)) {
            $this->inviter_id = (int) $row->inviter_id;
        }

        $this->date_modified = $row->date_modified;
        $this->date_modified_gmt = $row->date_modified_gmt;
    }

    private function exists() {
        return (NULL != $status = $this->db->get_var("SELECT `id` FROM $this->table $this->where_string"));
    }

    public function rsvp($status) {
        return $this->set_status($status);
    }

    public function invite() {

        if(get_current_user_id() == $this->user_id) {
            // Inviting yourself is like saying "yes"
            return $this->set_status('yes');
        }

        if($this->exists) {
            // Cannot, record already exists
            return FALSE;
        }

        $this->inviter_id = get_current_user_id();
        
        return $this->set_status('invited', get_current_user_id());
    }

    private function set_status($status, $inviter_id = FALSE) {
        if(!in_array($status, PeepSOWPEM_RSVP_User::$states)) {
            $status = PeepSOWPEM_RSVP_User::$default_state;
        }

        $data = ['status'=>$status,'date_modified'=>current_time('mysql'),'date_modified_gmt'=>current_time('mysql', TRUE)];

        if($this->exists) {
            $this->db->update($this->table, $data, $this->where);
        } else {
            $data = array_merge($data, $this->where);
            $this->db->insert($this->table, $data);
        }

        $this->init();
        $this->status = $status;

        // Generate notifications and post stream
        do_action('peepso_wpem_user_rsvp', ['user_id'=>$this->user_id,'event_id'=>$this->event_id,'inviter_id'=>$this->inviter_id, 'status'=>$this->status]);

        return $this;
    }
}

