<?php

class PeepSOWPEM_RSVP_Users {

    public $event_id;

    private $db;
    private $table;

    public function __construct(int $event_id) {
        $this->event_id = $event_id;

        global $wpdb;
        $this->db = $wpdb;
        $this->table = $wpdb->prefix.PeepSOWPEM_RSVP::TABLE;
    }

    public function get($status = FALSE, $exclude_author_or_list = FALSE, $limit = FALSE) {
        global $wpdb;

        $query = "SELECT `user_id` FROM {$this->table} WHERE `event_id`={$this->event_id} ";

        if($status) {
            $query .= " AND `status`='$status' ";
        }

        if(TRUE === $exclude_author_or_list) {
            $exclude_author_or_list = (int) get_post($this->event_id)->post_author;
        }

        if(is_int($exclude_author_or_list)) {
            $exclude_author_or_list = [$exclude_author_or_list];
        }

        if(is_array($exclude_author_or_list)) {
            $query .= " AND `user_id` NOT IN (" . implode(',',$exclude_author_or_list) . ") ";
        }

        $query .= " ORDER BY date_modified_gmt DESC ";

        if($limit) {
            $query .= "LIMIT $limit";
        }

        $results = $wpdb->get_results($query);

        $list = [];
        if(count($results)) {
            $i=0;
            foreach ($results as $row) {
                $list[] =$row->user_id;
            }
        }

        return $list;
    }
}