<?php

global $post;
$limit = PeepSo::get_option_new('wpem_rsvp_sidebar_attendees');
$PeepSOWPEM_RSVP_Users = new PeepSOWPEM_RSVP_Users($post->ID);

$going_all = $PeepSOWPEM_RSVP_Users->get('yes');
$maybe_all = $PeepSOWPEM_RSVP_Users->get('maybe');

$going = $PeepSOWPEM_RSVP_Users->get('yes', FALSE, $limit);
$going_count = count($going);
$maybe_count = 0;
$going_all_count = count($going_all);
$maybe_all_count = count($maybe_all);

if( $going_count < $limit) {
    $maybe = $PeepSOWPEM_RSVP_Users->get('maybe', FALSE, $limit - $going_count);
    $maybe_count = count($maybe);
}

if (!is_embed()) {
    if($space) { ?>
        <div class="clearfix">&nbsp;</div>
    <?php } ?>


    <h3 class="wpem-heading-text"><?php echo __('Attendees','peepso-wpem');?></h3>
    <div class="ps-wpem__attendees" >
        <?php
        
        echo "<div class='ps-wpem__attendees-list'>";
        
            if($going_count) {
                foreach($going as $user_id) {
                    PeepSoTemplate::exec_template('attendees','name',['user_id'=>$user_id,'status'=>'yes']);
                }
            }

            if($maybe_count) {
                foreach($maybe as $user_id) {
                    PeepSoTemplate::exec_template('attendees','name',['user_id'=>$user_id,'status'=>'maybe']);
                }
            }
        
        echo "</div>";

        if(!$maybe_all_count && !$going_all_count) {
            echo __('Nobody joined yet','peepso-wpem');
        } else {
            echo "<div class='ps-wpem__attendees-desc'>";

            if ($going_all_count) {
                echo "<span>".sprintf(_n('%d going', '%d going', $going_all_count, 'peepso-wpem'), $going_all_count)."</span>";
            }

            if ($maybe_all_count) {
                if($going_all_count) {
                    echo " &nbsp; ";
                }
                echo "<span>".sprintf(_n('%d interested', '%d interested', $maybe_all_count, 'peepso-wpem'), $maybe_all_count)."</span>";
            }

            echo "</div>";
        }


        ?>
    </div>
    <?php
} else {
    if($maybe_count || $going_count) {
        echo ' ' . __('Attendees', 'peepso-wpem') . ': ';

        if ($going_count) {
            echo sprintf(_n('%d going', '%d going', $going_count, 'peepso-wpem'), $going_count);
        }

        if ($maybe_count) {
            if($going_count) {
                echo ", ";
            }
            echo sprintf(_n('%d interested', '%d interested', $maybe_count, 'peepso-wpem'), $maybe_count);
        }
        echo ".";

    }
}