<?php
/**
 * The Template for displaying product archives, including the main shop page which is a post type archive
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/archive-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 8.6.0
 */

defined( 'ABSPATH' ) || exit;

get_header( 'shop' );

$gecko_settings = GeckoConfigSettings::get_instance();

//  Options page settings
$full_width_layout       = get_post_meta(get_proper_ID(), 'gecko-page-full-width', true);
$builder_friendly_layout = get_post_meta(get_proper_ID(), 'gecko-page-builder-friendly', true);
$hide_sidebars           = get_post_meta(get_proper_ID(), 'gecko-page-sidebars', true);
$hide_sidebars_woo       = $gecko_settings->get_option( 'opt_woo_sidebars', 1 );
$main_class              = "";

if (is_active_sidebar( 'sidebar-left' ) && ($hide_sidebars == 'right' || !$hide_sidebars)) {
  $main_class = "main--left";
}

if (is_active_sidebar( 'sidebar-right' ) && ($hide_sidebars == 'left' || !$hide_sidebars)) {
  $main_class = "main--right";
}

if (is_active_sidebar( 'sidebar-left' ) && is_active_sidebar( 'sidebar-right' ) && !$hide_sidebars) {
  $main_class = "main--both";
}

if ($hide_sidebars_woo == 0) {
	$hide_sidebars = 1;
	$main_class = "";
}
?>
<div id="main" class="main main--single <?php echo $main_class; if ($full_width_layout == 1) : echo " main--full"; endif; if ($builder_friendly_layout == 1) : echo " main--builder"; endif; ?>">
  	<!-- ABOVE CONTENT WIDGETS -->
  	<?php get_template_part( 'template-parts/widgets/above-content' ); ?>
	<!-- end: ABOVE CONTENT WIDGETS -->
	<?php if (($hide_sidebars == 'left' || $hide_sidebars == 'both') || $hide_sidebars == 1) {
		// do nothing
	} else {
		get_sidebar('left');
	}
	?>

	<?php if (($hide_sidebars == 'right' || $hide_sidebars == 'both' || $hide_sidebars == 1)) {
		// do nothing
	} else {
		get_sidebar('right');
	}
	?>
	<div class="content">
<?php
/**
 * Hook: woocommerce_before_main_content.
 *
 * @hooked woocommerce_output_content_wrapper - 10 (outputs opening divs for the content)
 * @hooked woocommerce_breadcrumb - 20
 * @hooked WC_Structured_Data::generate_website_data() - 30
 */
do_action( 'woocommerce_before_main_content' );

/**
 * Hook: woocommerce_shop_loop_header.
 *
 * @since 8.6.0
 *
 * @hooked woocommerce_product_taxonomy_archive_header - 10
 */
do_action( 'woocommerce_shop_loop_header' );

if ( woocommerce_product_loop() ) {

	/**
	 * Hook: woocommerce_before_shop_loop.
	 *
	 * @hooked woocommerce_output_all_notices - 10
	 * @hooked woocommerce_result_count - 20
	 * @hooked woocommerce_catalog_ordering - 30
	 */
	do_action( 'woocommerce_before_shop_loop' );

	woocommerce_product_loop_start();

	if ( wc_get_loop_prop( 'total' ) ) {
		while ( have_posts() ) {
			the_post();

			/**
			 * Hook: woocommerce_shop_loop.
			 */
			do_action( 'woocommerce_shop_loop' );

			wc_get_template_part( 'content', 'product' );
		}
	}

	woocommerce_product_loop_end();

	/**
	 * Hook: woocommerce_after_shop_loop.
	 *
	 * @hooked woocommerce_pagination - 10
	 */
	do_action( 'woocommerce_after_shop_loop' );
} else {
	/**
	 * Hook: woocommerce_no_products_found.
	 *
	 * @hooked wc_no_products_found - 10
	 */
	do_action( 'woocommerce_no_products_found' );
}

/**
 * Hook: woocommerce_after_main_content.
 *
 * @hooked woocommerce_output_content_wrapper_end - 10 (outputs closing divs for the content)
 */
do_action( 'woocommerce_after_main_content' );
?>
	</div>

<!-- UNDER CONTENT WIDGETS -->
<?php get_template_part( 'template-parts/widgets/under-content' ); ?>
<!-- end: UNDER CONTENT WIDGETS -->

<?php if (($hide_sidebars == 'right' || $hide_sidebars == 'both' || $hide_sidebars == 1)) {
// do nothing
} else {
	get_sidebar('right');
}
?>
</div>
<?php
/**
 * Hook: woocommerce_sidebar.
 *
 * @hooked woocommerce_get_sidebar - 10
 */
do_action( 'woocommerce_sidebar' );

get_footer( 'shop' );
