<?php 
/* Child theme generated with WPS Child Theme Generator */
            
if ( ! function_exists( 'b7ectg_theme_enqueue_styles' ) ) {            
    add_action( 'wp_enqueue_scripts', 'b7ectg_theme_enqueue_styles' );
    
    function b7ectg_theme_enqueue_styles() {
        wp_enqueue_style( 'parent-style', get_template_directory_uri() . '/style.css' );
        wp_enqueue_style( 'child-style', get_stylesheet_directory_uri() . '/style.css', array( 'parent-style' ) );
    }
}

/****************************************************************/
/* MODIFIER LE LOGO SUR LA PAGE DE CONNEXION À L'ADMINISTRATION */
/****************************************************************/

function wpm_login_style() { ?>
    <link rel="stylesheet" type="text/css" href="/wp-content/themes/resiliencedotci-peepso-theme-gecko-child/assets/css/legacy.css">
<?php }
add_action( 'login_enqueue_scripts', 'wpm_login_style' );

// changer l'URL du logo de la page de connexion afin qu'elle pointe vers votre site
function my_login_logo_url() {
return 'https://resilience.ci/';
}
add_filter( 'login_headerurl', 'my_login_logo_url' );

function my_login_logo_url_title() {
 return 'Libérez-vous ! Rejoignez Resilience.ci !';
}
add_filter( 'login_headertitle', 'my_login_logo_url_title' );

function my_login_logo_url_text() {
 return 'Vous souhaitez <u>vous connecter</u> <u>ou votre session</u> <u>a expiré.</u> Veuillez <u>vous connecter</u> <u>ou vous reconnecter</u> <u>pour reprendre</u> <u>à la dernière</u> page visitée.<br /><u>Si nécessaire,</u> rechargez <u>la page</u> <u>une fois connecté.</u>';
}
add_filter( 'login_messages', 'my_login_logo_url_text' );


/******************************************/
/*           SECURITE WORDPRESS           */
/******************************************/

// // Suppression du login de l'auteur dans les commentaires
function remove_comment_author_class( $classes ) {
 foreach( $classes as $key => $class )
  if(strstr($class, 'comment-author-' ))
   unset( $classes[$key] );
 return $classes;
}
add_filter( 'comment_class' , 'remove_comment_author_class' );
// Désactivation des infos d'erreur de login
function remove_login_error_msg() {
 return 'Et alors...?';
}
add_filter( 'login_errors', 'remove_login_error_msg' );
// Désactivation XMLRPC
add_filter( 'xmlrpc_enabled', '__return_false' );
remove_action('wp_head', 'rsd_link');
add_filter('bloginfo_url', function($output, $property){
    return ($property == 'pingback_url') ? null : $output;
}, 11, 2);
add_filter( 'wp_headers', function($headers) {
    unset( $headers['X-Pingback'] );
  return $headers;
});
// Suppression de la version de WordPress
// remove_action('wp_head', 'wp_generator');
// Suppression version dans flux RSS
function remove_version_wp() {
 return '';
}
add_filter(‘the_generator’, ‘remove_version_wp’);
// Suppression des versions des fichiers css/js inclus
function remove_ver_css_js( $src ) {
 if ( strpos( $src, 'ver=' . get_bloginfo( 'version' ) ) )
  $src = remove_query_arg( 'ver', $src );
 return $src;
}
add_filter( 'style_loader_src', 'remove_ver_css_js', 9999 );
add_filter( 'script_loader_src', 'remove_ver_css_js', 9999 );